/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.potion.PotionIllFitting;
import net.msrandom.witchery.util.EarthItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J(\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a8\u0006\u001a"}, d2={"Lnet/msrandom/witchery/item/brews/ItemErosionBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "damageEquipment", "", "stack", "Lnet/minecraft/item/ItemStack;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "meltLine", "", "start", "Lnet/minecraft/util/math/BlockPos;", "end", "meltObsidian", "pos", "radius", "WitcheryResurrected"})
public final class ItemErosionBrew
extends ItemKettleBrew {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectile), (String)"projectile");
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        if (hit.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = hit.getBlockPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"hit.blockPos");
            if (WitcheryUtils.isBlockBreakable$default(world, blockPos, null, 2, null)) {
                int obsidianMelted = 0;
                int n = 2;
                boolean bl = false;
                while (n >= 0) {
                    void i;
                    int y = 2 - i;
                    BlockPos blockPos2 = hit.getBlockPos().up(y);
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"hit.blockPos.up(y)");
                    obsidianMelted += this.meltObsidian(world, projectile, blockPos2, (int)i);
                    if (y != 0) {
                        BlockPos blockPos3 = hit.getBlockPos().down(y);
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"hit.blockPos.down(y)");
                        obsidianMelted += this.meltObsidian(world, projectile, blockPos3, (int)i);
                    }
                    --i;
                }
                if (obsidianMelted > 0) {
                    BlockPos blockPos4 = hit.getBlockPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"hit.blockPos");
                    double d = (double)blockPos4.getX() + 0.5;
                    BlockPos blockPos5 = hit.getBlockPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"hit.blockPos");
                    double d2 = (double)blockPos5.getY() + 0.5;
                    BlockPos blockPos6 = hit.getBlockPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"hit.blockPos");
                    world.spawnEntity((Entity)new EntityItem(world, d, d2, (double)blockPos6.getZ() + 0.5, new ItemStack(Blocks.OBSIDIAN, obsidianMelted)));
                }
            }
        } else if (hit.typeOfHit == RayTraceResult.Type.ENTITY) {
            Entity entity = hit.entityHit;
            if (entity instanceof EntityLivingBase) {
                float damage = enhanced ? 10.0f : 8.0f;
                entity.attackEntityFrom(DamageSource.causeThrownDamage((Entity)entity, (Entity)((Entity)caster)), damage);
                for (EntityEquipmentSlot slot : PotionIllFitting.SLOTS) {
                    ItemStack itemStack = ((EntityLivingBase)entity).getItemStackFromSlot(slot);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"entity.getItemStackFromSlot(slot)");
                    this.damageEquipment(itemStack, caster);
                }
            } else {
                world.spawnEntity((Entity)new EntityItem(world, hit.entityHit.posX, hit.entityHit.posY, hit.entityHit.posZ, new ItemStack((Item)this)));
                return false;
            }
        }
        return true;
    }

    private final int meltObsidian(World world, EntityWitchProjectile projectile, BlockPos pos, int radius) {
        int x = radius;
        int z = 0;
        int radiusError = 1 - x;
        int obsidianMelted = 0;
        while (x >= z) {
            BlockPos blockPos = pos.add(-x, 0, z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.add(-x, 0, z)");
            BlockPos blockPos2 = pos.add(x, 0, z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.add(x, 0, z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos, blockPos2);
            BlockPos blockPos3 = pos.add(-z, 0, x);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos.add(-z, 0, x)");
            BlockPos blockPos4 = pos.add(z, 0, x);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"pos.add(z, 0, x)");
            obsidianMelted += this.meltLine(world, projectile, blockPos3, blockPos4);
            BlockPos blockPos5 = pos.add(-x, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"pos.add(-x, 0, -z)");
            BlockPos blockPos6 = pos.add(x, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"pos.add(x, 0, -z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos5, blockPos6);
            BlockPos blockPos7 = pos.add(-z, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"pos.add(-z, 0, -z)");
            BlockPos blockPos8 = pos.add(z, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos8, (String)"pos.add(z, 0, -z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos7, blockPos8);
            radiusError += radiusError < 0 ? 2 * z + 1 : 2 * (++z - --x + 1);
        }
        return obsidianMelted;
    }

    private final int meltLine(World world, EntityWitchProjectile projectile, BlockPos start, BlockPos end) {
        int obsidianMelted = 0;
        for (BlockPos pos : WitcheryUtils.rangeTo(start, end)) {
            IBlockState state;
            IBlockState iBlockState = state = world.getBlockState(pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (iBlockState.getBlock() == Blocks.OBSIDIAN) {
                ++obsidianMelted;
            }
            if (!WitcheryUtils.isBlockBreakable(world, pos, state) || !state.isFullCube()) continue;
            world.setBlockToAir(pos);
            WitcheryUtils.addNewParticles$default(world, EnumParticleTypes.WATER_SPLASH, projectile.posX, projectile.posY, projectile.posZ, 0.0, 20, 0.0, 0.0, 192, null);
        }
        return obsidianMelted;
    }

    private final void damageEquipment(ItemStack stack, EntityLivingBase caster) {
        if (stack.isItemStackDamageable() && EarthItems.instance().isMatch(stack)) {
            EntityLivingBase entityLivingBase = caster;
            if (entityLivingBase != null) {
                EntityLivingBase entityLivingBase2 = entityLivingBase;
                boolean bl = false;
                boolean bl2 = false;
                EntityLivingBase it = entityLivingBase2;
                boolean bl3 = false;
                stack.damageItem(100, it);
            } else {
                stack.attemptDamageItem(100, ItemErosionBrew.access$getItemRand$p$s2289459(), null);
            }
        }
    }

    public ItemErosionBrew() {
        super(false, 1, null);
    }

    public static final /* synthetic */ Random access$getItemRand$p$s2289459() {
        return Item.itemRand;
    }

    public static final /* synthetic */ void access$setItemRand$p$s2289459(Random random) {
        Item.itemRand = random;
    }
}

