/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lnet/msrandom/witchery/item/brews/ItemDrinkableBrew;", "Lnet/minecraft/item/Item;", "effects", "", "Lnet/minecraft/potion/PotionEffect;", "([Lnet/minecraft/potion/PotionEffect;)V", "[Lnet/minecraft/potion/PotionEffect;", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "stack", "Lnet/minecraft/item/ItemStack;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "getMaxItemUseDuration", "", "onDrunk", "", "world", "Lnet/minecraft/world/World;", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUseFinish", "entityLiving", "WitcheryResurrected"})
public class ItemDrinkableBrew
extends Item {
    private final PotionEffect[] effects;

    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        player.setActiveHand(hand);
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"ActionResult.newResult(E\u2026player.getHeldItem(hand))");
        return actionResult;
    }

    @NotNull
    public EnumAction getItemUseAction(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumAction.DRINK;
    }

    public int getMaxItemUseDuration(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 32;
    }

    @NotNull
    public ItemStack onItemUseFinish(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entityLiving) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)entityLiving, (String)"entityLiving");
        for (PotionEffect effect : this.effects) {
            entityLiving.addPotionEffect(new PotionEffect(effect));
        }
        if (!(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).capabilities.isCreativeMode) {
            stack.shrink(1);
        }
        if (!world.isRemote) {
            if (entityLiving instanceof EntityPlayerMP) {
                CriteriaTriggers.CONSUME_ITEM.trigger((EntityPlayerMP)entityLiving, stack);
                ((EntityPlayerMP)entityLiving).addStat(StatList.getObjectUseStats((Item)this));
            }
            this.onDrunk(stack, world, entityLiving);
            ItemStack itemStack = entityLiving.getHeldItem(entityLiving.getActiveHand());
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"entityLiving.getHeldItem(entityLiving.activeHand)");
            return itemStack;
        }
        ItemStack itemStack = super.onItemUseFinish(stack, world, entityLiving);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"super.onItemUseFinish(stack, world, entityLiving)");
        return itemStack;
    }

    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumRarity.RARE;
    }

    protected void onDrunk(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
    }

    public ItemDrinkableBrew(PotionEffect ... effects2) {
        Intrinsics.checkParameterIsNotNull((Object)effects2, (String)"effects");
        this.effects = effects2;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }
}

