/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/item/brews/ItemCursedLeapingBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "WitcheryResurrected"})
public final class ItemCursedLeapingBrew
extends ItemKettleBrew {
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectile), (String)"projectile");
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        Entity livingEntity = hit.entityHit;
        double r = 5.0;
        AxisAlignedBB axisalignedbb = projectile.getEntityBoundingBox().expand(r, 2.0, r);
        for (EntityLivingBase entity : world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb)) {
            double d;
            double distance = entity.getDistanceSq((Entity)projectile);
            if (!(distance < r * r)) continue;
            double d2 = 1.0;
            if (entity == livingEntity) {
                d = 0.0;
            } else {
                double d3 = d2;
                boolean bl = false;
                double d4 = Math.sqrt(distance);
                d2 = d3;
                d = d4 / r * 0.25;
            }
            double power = d2 - d;
            double leap = power * 1.6;
            entity.addPotionEffect(new PotionEffect(MobEffects.JUMP_BOOST, 200, 3));
            if (entity instanceof EntityPlayerMP) {
                WitcheryNetworkChannel.sendTo(new PacketPushTarget(entity.motionX, entity.motionY + leap, entity.motionZ), (EntityPlayerMP)entity);
                continue;
            }
            entity.motionY += leap;
        }
        return true;
    }

    public ItemCursedLeapingBrew() {
        super(false, 1, null);
    }
}

