/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityPoppetShelf;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.Taglockable;
import net.msrandom.witchery.item.ingredients.IngredientItem;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.registry.WitcheryNamespacedInitializer;

public class WitcheryPoppetItems
extends WitcheryNamespacedInitializer<Item> {
    public static final WitcheryPoppetItems INSTANCE = new WitcheryPoppetItems();
    public static final ItemPoppet POPPET = WitcheryPoppetItems.register("poppet", new ItemPoppet(EnumRarity.COMMON));
    public static final ItemPoppet EARTH_PROTECTION = WitcheryPoppetItems.register("earth_protection_poppet", new ItemPoppet());
    public static final ItemPoppet WATER_PROTECTION = WitcheryPoppetItems.register("water_protection_poppet", new ItemPoppet());
    public static final ItemPoppet FIRE_PROTECTION = WitcheryPoppetItems.register("fire_protection_poppet", new ItemPoppet());
    public static final ItemPoppet STARVATION_PROTECTION = WitcheryPoppetItems.register("hunger_protection_poppet", new ItemPoppet());
    public static final ItemPoppet TOOL_PROTECTION = WitcheryPoppetItems.register("tool_protection_poppet", new ItemPoppet());
    public static final ItemPoppet DEATH_PROTECTION = WitcheryPoppetItems.register("death_protection_poppet", new ItemPoppet(EnumRarity.RARE));
    public static final ItemPoppet VOODOO_PROTECTION = WitcheryPoppetItems.register("voodoo_protection_poppet", (ItemPoppet)new ItemPoppet().setMaxDamage(1000));
    public static final ItemPoppet VOODOO = WitcheryPoppetItems.register("voodoo_poppet", new ItemPoppet().doesNotBreak());
    public static final ItemPoppet VAMPIRIC = WitcheryPoppetItems.register("vampiric_poppet", new ItemPoppet(EnumRarity.RARE){

        @Override
        public int getTaglockCount() {
            return 2;
        }
    }.doesNotBreak());
    public static final ItemPoppet POPPET_PROTECTION = WitcheryPoppetItems.register("poppet_protection_poppet", new ItemPoppet(EnumRarity.RARE).doesNotBreak());
    public static final ItemPoppet ARMOR_PROTECTION = WitcheryPoppetItems.register("armor_protection_poppet", new ItemPoppet());

    public WitcheryPoppetItems() {
        super(RegistryWrappers.ITEMS, "witchery", "items/poppets");
    }

    private static <A extends Item> A register(String name2, A poppet) {
        return WitcheryGeneralItems.register(name2, poppet, INSTANCE.getRegistrar());
    }

    public static ItemStack findBoundPoppetInWorld(ItemPoppet poppetType, EntityPlayer player, int foundItemDamage) {
        return WitcheryPoppetItems.findBoundPoppetInWorld(poppetType, player, foundItemDamage, false, false);
    }

    public static ItemStack findBoundPoppetInWorld(ItemPoppet poppetType, EntityPlayer player, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        if (ItemHunterClothes.isFullSetWorn((EntityLivingBase)player, false)) {
            return null;
        }
        ItemStack poppetStack = WitcheryPoppetItems.findBoundPoppetInInventory(poppetType, player, (IInventory)player.inventory, foundItemDamage, allIndices, onlyBoosted);
        if (poppetStack != null) {
            return poppetStack;
        }
        if (!player.world.isRemote && !onlyBoosted) {
            MinecraftServer server = player.getServer();
            for (WorldServer world : server.worlds) {
                if (WitcheryConfigOptions.restrictPoppetShelvesToVanillaAndSpiritDimensions && world.provider.getDimension() != 0 && world.provider.getDimension() != -1 && world.provider.getDimension() != 1 && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension((World)world)) continue;
                for (TileEntity obj : world.loadedTileEntityList) {
                    if (!(obj instanceof TileEntityPoppetShelf) || (poppetStack = WitcheryPoppetItems.findBoundPoppetInInventory(poppetType, player, (IInventory)obj, foundItemDamage, allIndices, false)) == null) continue;
                    return poppetStack;
                }
            }
        }
        return null;
    }

    @Nullable
    private static ItemStack findBoundPoppetInInventory(ItemPoppet item, EntityPlayer player, IInventory inventory, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.getItem() != item || !ItemTaglockKit.containsTaglockForEntity(itemstack, (Entity)player, 0) || allIndices && !ItemTaglockKit.isTaglockPresent(itemstack, 1)) continue;
            if (!onlyBoosted) {
                item.applyDamageOnUse(player, itemstack, foundItemDamage);
                return itemstack;
            }
            if (WitcheryPoppetItems.voodooProtection(player)) {
                item.applyDamageOnUse(player, itemstack, foundItemDamage);
                return itemstack;
            }
            return null;
        }
        return null;
    }

    private static boolean voodooProtection(EntityPlayer player) {
        for (Map.Entry entry2 : InfusedSpiritEffect.REGISTRY) {
            if (!((InfusedSpiritEffect)entry2.getValue()).isVoodooProtection() || !((InfusedSpiritEffect)entry2.getValue()).isNearTo(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning, boolean onlyBoosted) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        if (targetEntity instanceof EntityPlayer && (defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(VOODOO_PROTECTION, targetPlayer = (EntityPlayer)targetEntity, 350, false, onlyBoosted)) != null && !targetPlayer.world.isRemote) {
            if (attackingEntity != null && !voodooStack.isEmpty()) {
                voodooStack.damageItem(350, (EntityLivingBase)attackingEntity);
            }
            if (attackingEntity != null && allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.world, attackingEntity.posX, attackingEntity.posY, attackingEntity.posZ, false);
                attackingEntity.world.addWeatherEffect((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public static boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, int strength) {
        if (!(strength <= 1 || targetEntity instanceof EntityPlayer && WitcheryPoppetItems.voodooProtection((EntityPlayer)targetEntity))) {
            for (int i = 1; i <= strength; ++i) {
                boolean allowLightning;
                boolean bl = allowLightning = i == strength;
                if (WitcheryPoppetItems.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, allowLightning, false)) continue;
                return false;
            }
            return true;
        }
        return WitcheryPoppetItems.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, true, false);
    }

    public static boolean poppetProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        if (targetEntity instanceof EntityPlayer && (defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(POPPET_PROTECTION, targetPlayer = (EntityPlayer)targetEntity, 350)) != null && !attackingEntity.world.isRemote) {
            if (!voodooStack.isEmpty()) {
                voodooStack.damageItem(350, (EntityLivingBase)attackingEntity);
            }
            if (allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.world, attackingEntity.posX, attackingEntity.posY, attackingEntity.posZ, false);
                attackingEntity.world.addWeatherEffect((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public static void destroyAntiVoodooPoppets(EntityLivingBase targetEntity, int poppetsToDestroy) {
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            for (int i = 0; i < poppetsToDestroy; ++i) {
                ItemStack defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(VOODOO_PROTECTION, targetPlayer, 1000);
                if (defenseStack != null) continue;
                return;
            }
        }
    }

    public static void cancelEventIfPoppetFound(EntityPlayer player, ItemPoppet poppetType, LivingHurtEvent event, boolean heal, boolean onlyHandheld) {
        ItemStack stack = WitcheryPoppetItems.findBoundPoppetInWorld(poppetType, player, 1000, false, onlyHandheld);
        if (stack != null) {
            event.setCanceled(true);
            if (heal && player.getHealth() < 10.0f) {
                player.setHealth(10.0f);
            }
            player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
        }
    }

    public static void cancelEventIfPoppetFound(EntityPlayer player, ItemPoppet poppetType, LivingHurtEvent event, boolean heal) {
        WitcheryPoppetItems.cancelEventIfPoppetFound(player, poppetType, event, heal, false);
    }

    public static void checkForArmorProtection(EntityPlayer player) {
        for (int i = 0; i < player.inventory.armorInventory.size(); ++i) {
            ItemStack protectStack;
            int maxDamage;
            int repairThreshold;
            int itemDamage;
            ItemStack armorPiece = (ItemStack)player.inventory.armorInventory.get(i);
            if (armorPiece.isEmpty() || !armorPiece.isItemStackDamageable() || (itemDamage = armorPiece.getItemDamage()) < (repairThreshold = (int)((float)(maxDamage = armorPiece.getMaxDamage()) * 0.9f)) || (protectStack = WitcheryPoppetItems.findBoundPoppetInWorld(ARMOR_PROTECTION, player, 1000)) == null) continue;
            armorPiece.setItemDamage(0);
            player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.world.rand.nextDouble() * 0.4f + 0.8f));
        }
    }

    public static class ItemPoppet
    extends Item
    implements Taglockable {
        private final EnumRarity rarity;
        private boolean destroyOnUse = true;

        private ItemPoppet() {
            this(EnumRarity.UNCOMMON);
        }

        private ItemPoppet(EnumRarity rarity) {
            this.rarity = rarity;
            this.setCreativeTab(WitcheryGeneralItems.TAB);
            this.setNoRepair();
            this.setMaxStackSize(1);
        }

        @SideOnly(value=Side.CLIENT)
        public EnumRarity getRarity(ItemStack itemstack) {
            return ((ItemPoppet)itemstack.getItem()).rarity;
        }

        public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
            ItemPoppet type = (ItemPoppet)stack.getItem();
            int count = type.getTaglockCount();
            boolean empty = true;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                ITextComponent name2 = this.getBloodName(stack, i);
                if (name2 != null) {
                    empty = false;
                }
                builder.append(name2 == null ? "??" : name2.getFormattedText());
                if (i == count - 1) continue;
                builder.append(" -> ");
            }
            if (empty) {
                list2.add(I18n.format((String)(WitcheryGeneralItems.TAGLOCK_KIT.getTranslationKey() + ".unbound"), (Object[])new Object[0]));
            } else {
                list2.add(TextFormatting.DARK_PURPLE + builder.toString());
            }
        }

        public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
            EntityLivingBase boundEntity;
            if (!world.isRemote && stack.getItem() == VOODOO && entity.isInsideOfMaterial(Material.WATER) && entity.getAir() <= 0 && (boundEntity = ItemTaglockKit.getBoundEntity(world, stack, 0)) != null && boundEntity.isEntityAlive() && !WitcheryPoppetItems.voodooProtectionActivated(entity instanceof EntityPlayer ? (EntityPlayer)entity : null, stack, boundEntity, true, false)) {
                boolean damageDisabled;
                if (entity instanceof EntityPlayer) {
                    EntityWitchHunter.blackMagicPerformed((EntityPlayer)entity);
                }
                boolean bl = damageDisabled = boundEntity instanceof EntityPlayer && ((EntityPlayer)boundEntity).capabilities.disableDamage;
                if (ItemHunterClothes.isMagicalProtectionActive(boundEntity) && !boundEntity.canBreatheUnderwater() && !boundEntity.isPotionActive(MobEffects.WATER_BREATHING) && !damageDisabled) {
                    for (int i = 0; i < 8; ++i) {
                        float f = world.rand.nextFloat() - world.rand.nextFloat();
                        float f2 = world.rand.nextFloat() - world.rand.nextFloat();
                        float f3 = world.rand.nextFloat() - world.rand.nextFloat();
                        world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, boundEntity.posX + (double)f, boundEntity.posY + (double)f2, boundEntity.posZ + (double)f3, boundEntity.motionX, boundEntity.motionY, boundEntity.motionZ, new int[0]);
                    }
                    boundEntity.attackEntityFrom(DamageSource.DROWN, 1.0f);
                }
                boundEntity.extinguish();
            }
            super.onUpdate(stack, world, entity, par4, par5);
        }

        public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
            if (player.getHeldItem(hand).getItem() == VOODOO) {
                player.setActiveHand(hand);
            }
            return super.onItemRightClick(world, player, hand);
        }

        public int getMaxItemUseDuration(ItemStack par1ItemStack) {
            return 80;
        }

        public EnumAction getItemUseAction(ItemStack par1ItemStack) {
            return EnumAction.BOW;
        }

        public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityLivingBase livingBase, int ticks) {
            if (!world.isRemote && livingBase instanceof EntityPlayer) {
                EntityLivingBase entity;
                EntityPlayer player = (EntityPlayer)livingBase;
                if (itemstack.getItem() == VOODOO && (entity = ItemTaglockKit.getBoundEntity(world, itemstack, 0)) != null) {
                    IBlockState hitBlock;
                    Material hitMaterial;
                    EntityWitchHunter.blackMagicPerformed(player);
                    RayTraceResult hitObject = this.rayTrace(world, player, true);
                    if (hitObject != null && hitObject.typeOfHit == RayTraceResult.Type.BLOCK && (hitMaterial = (hitBlock = world.getBlockState(hitObject.getBlockPos())).getMaterial()) == Material.LAVA) {
                        if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false) && ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                            entity.setFire(10);
                        }
                        itemstack.shrink(1);
                        world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.4f, 2.0f + world.rand.nextFloat() * 0.4f);
                        return;
                    }
                    if (player.isSneaking()) {
                        int index = -1;
                        if (player.capabilities.isCreativeMode || (index = IngredientItem.getItemSlotFromInventory(player.inventory, WitcheryIngredientItems.BONE_NEEDLE)) != -1) {
                            PoppetDamageSource damageSource = new PoppetDamageSource((Entity)player);
                            if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false)) {
                                entity.attackEntityFrom((DamageSource)damageSource, 0.5f);
                                if (!player.capabilities.isCreativeMode) {
                                    if (index != -1) {
                                        player.inventory.getStackInSlot(index).shrink(1);
                                    }
                                    itemstack.damageItem(10, (EntityLivingBase)player);
                                }
                            }
                        }
                        return;
                    }
                    if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false) && ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                        Vec3d look = player.getLookVec();
                        float scaling = (this.getMaxItemUseDuration(itemstack) - ticks) / 20;
                        double motionX = look.x * 0.9 * (double)scaling;
                        double motionY = look.y * 0.3 * (double)scaling;
                        double motionZ = look.z * 0.9 * (double)scaling;
                        if (entity instanceof EntityPlayerMP) {
                            EntityPlayerMP targetPlayer = (EntityPlayerMP)entity;
                            WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                        } else {
                            entity.motionX = motionX;
                            entity.motionY = motionY;
                            entity.motionZ = motionZ;
                        }
                        itemstack.damageItem(10, (EntityLivingBase)player);
                    }
                    return;
                }
                super.onPlayerStoppedUsing(itemstack, world, (EntityLivingBase)player, ticks);
            }
        }

        public ItemPoppet doesNotBreak() {
            this.destroyOnUse = false;
            return this;
        }

        private void applyDamageOnUse(EntityPlayer player, ItemStack itemstack, int itemDamage) {
            if (itemstack.getMaxDamage() <= 0 && this.destroyOnUse) {
                itemstack.shrink(1);
            } else {
                itemstack.damageItem(itemDamage, (EntityLivingBase)player);
            }
        }
    }

    private static class PoppetDamageSource
    extends EntityDamageSource {
        private PoppetDamageSource(Entity source) {
            super(DamageSource.MAGIC.getDamageType(), source);
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }
    }
}

