/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lnet/msrandom/witchery/item/WitcheryItemSeeds;", "Lnet/minecraft/item/ItemBlock;", "Lnet/minecraftforge/common/IPlantable;", "block", "Lnet/minecraft/block/Block;", "(Lnet/minecraft/block/Block;)V", "getPlant", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "worldIn", "Lnet/minecraft/world/World;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "WitcheryResurrected"})
public class WitcheryItemSeeds
extends ItemBlock
implements IPlantable {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public EnumActionResult onItemUse(@NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult enumActionResult;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack stack = player.getHeldItem(hand);
        IBlockState state = worldIn.getBlockState(pos);
        if (facing == EnumFacing.UP && player.canPlayerEdit(pos.offset(facing), facing, stack)) {
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (iBlockState.getBlock().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.isAirBlock(pos.up())) {
                BlockPos blockPos = pos.up();
                Block block = this.block;
                Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"block");
                worldIn.setBlockState(blockPos, block.getDefaultState());
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)player, pos.up(), stack);
                }
                stack.shrink(1);
                enumActionResult = EnumActionResult.SUCCESS;
                return enumActionResult;
            }
        }
        enumActionResult = EnumActionResult.FAIL;
        return enumActionResult;
    }

    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return EnumPlantType.Crop;
    }

    @NotNull
    public IBlockState getPlant(@Nullable IBlockAccess world, @Nullable BlockPos pos) {
        Block block = this.block;
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"block");
        IBlockState iBlockState = block.getDefaultState();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"block.defaultState");
        return iBlockState;
    }

    public WitcheryItemSeeds(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        super(block);
    }
}

