/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.entity.item.EntityWitchBoat;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/item/WitcheryItemBoat;", "Lnet/minecraft/item/Item;", "woodType", "Lnet/msrandom/witchery/block/WitcheryWoodType;", "(Lnet/msrandom/witchery/block/WitcheryWoodType;)V", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "WitcheryResurrected"})
public final class WitcheryItemBoat
extends Item {
    private final WitcheryWoodType woodType;

    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        ActionResult actionResult;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = player.getHeldItem(hand);
        float pitch = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch);
        float yaw = player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw);
        double x = player.prevPosX + (player.posX - player.prevPosX);
        double y = player.prevPosY + (player.posY - player.prevPosY) + (double)player.getEyeHeight();
        double z = player.prevPosZ + (player.posZ - player.prevPosZ);
        Vec3d vec3d = new Vec3d(x, y, z);
        float rotation = -MathHelper.cos((float)(-WitcheryUtils.toRadians(pitch)));
        Vec3d vec3d1 = vec3d.add((double)(MathHelper.sin((float)(-WitcheryUtils.toRadians(yaw) - (float)Math.PI)) * rotation) * 5.0, (double)MathHelper.sin((float)(-WitcheryUtils.toRadians(pitch))) * 5.0, (double)(MathHelper.cos((float)(-WitcheryUtils.toRadians(yaw) - (float)Math.PI)) * rotation) * 5.0);
        RayTraceResult hit = world.rayTraceBlocks(vec3d, vec3d1, true);
        if (hit == null) {
            actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
        } else {
            Vec3d vec3d2 = player.getLook(1.0f);
            boolean colliding = false;
            for (Entity entity : world.getEntitiesWithinAABBExcludingEntity((Entity)player, player.getEntityBoundingBox().expand(vec3d2.x * 5.0, vec3d2.y * 5.0, vec3d2.z * 5.0).grow(1.0))) {
                if (!entity.canBeCollidedWith()) continue;
                Entity entity2 = entity;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
                if (!entity2.getEntityBoundingBox().grow((double)entity.getCollisionBorderSize()).contains(vec3d)) continue;
                colliding = true;
            }
            if (colliding) {
                actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
            } else if (hit.typeOfHit != RayTraceResult.Type.BLOCK) {
                actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
            } else {
                IBlockState iBlockState = world.getBlockState(hit.getBlockPos());
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(hit.blockPos)");
                Block block = iBlockState.getBlock();
                boolean onWater = block == Blocks.WATER || block == Blocks.FLOWING_WATER;
                EntityWitchBoat boat2 = new EntityWitchBoat(world, hit.hitVec.x, onWater ? hit.hitVec.y - 0.12 : hit.hitVec.y, hit.hitVec.z, this.woodType);
                boat2.rotationYaw = player.rotationYaw;
                if (world.getCollisionBoxes((Entity)boat2, boat2.getEntityBoundingBox().grow(-0.1)).isEmpty()) {
                    if (!world.isRemote) {
                        world.spawnEntity((Entity)boat2);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                    player.addStat(StatList.getObjectUseStats((Item)this));
                    actionResult = new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                } else {
                    actionResult = new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
            }
        }
        return actionResult;
    }

    public WitcheryItemBoat(@NotNull WitcheryWoodType woodType) {
        Intrinsics.checkParameterIsNotNull((Object)woodType, (String)"woodType");
        this.woodType = woodType;
        this.maxStackSize = 1;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }
}

