/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockVoidBramble;
import net.msrandom.witchery.client.model.ModelWitchesClothes;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.item.traits.Invisible;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemWitchesClothes
extends ItemArmor
implements Invisible {
    private static final int CHARGE_PER_PIECE = 2;
    private static final double WILD_EFFECT_CHANCE = 0.01;
    private static String noPlaceLikeHome;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelNecroChest;
    @SideOnly(value=Side.CLIENT)
    private ModelWitchesClothes modelClothesLegs;

    public ItemWitchesClothes(EntityEquipmentSlot armorSlot) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static int getMaxChargeLevel(EntityLivingBase entity) {
        int level = 0;
        for (int i = 2; i <= 5; ++i) {
            ItemStack stack = entity.getItemStackFromSlot(EntityEquipmentSlot.values()[i]);
            if (stack.isEmpty() || !(stack.getItem() instanceof ItemWitchesClothes)) continue;
            level += 2;
        }
        return level;
    }

    public static void setChargeLevel(ItemStack stack, int level) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = stack.getTagCompound();
        nbtRoot.setInteger("WitcheryBarkPieces", level);
    }

    public static int getChargeLevel(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (stack.hasTagCompound() && (nbtRoot = stack.getTagCompound()).hasKey("WitcheryBarkPieces")) {
            return nbtRoot.getInteger("WitcheryBarkPieces");
        }
        return 0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (!(stack.isEmpty() || stack.getItem() != WitcheryEquipmentItems.WITCH_HAT && stack.getItem() != WitcheryEquipmentItems.WITCH_ROBES && stack.getItem() != WitcheryEquipmentItems.NECROMANCERS_ROBES && stack.getItem() != WitcheryEquipmentItems.ICY_SLIPPERS && stack.getItem() != WitcheryEquipmentItems.RUBY_SLIPPERS && stack.getItem() != WitcheryEquipmentItems.SEEPING_SHOES && stack.getItem() != WitcheryEquipmentItems.BABAS_HAT)) {
            return "witchery:textures/entities/witchclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        if (!stack.isEmpty() && stack.getItem() == WitcheryEquipmentItems.BITING_BELT) {
            return "witchery:textures/entities/witchclothes_legs" + (type == null ? "" : "_overlay") + ".png";
        }
        if (!stack.isEmpty() && stack.getItem() == WitcheryEquipmentItems.BARK_BELT) {
            return "witchery:textures/entities/witchclothes" + (type == null ? "2_legs" : "_legs_overlay") + ".png";
        }
        return null;
    }

    public boolean hasColor(ItemStack stack) {
        return stack.isEmpty() || stack.getItem() != WitcheryEquipmentItems.BABAS_HAT;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return super.getColor(stack);
        }
        if (stack.getItem() == WitcheryEquipmentItems.RUBY_SLIPPERS) {
            return 0xDD0000;
        }
        int color2 = super.getColor(stack);
        if (color2 == 10511680) {
            color2 = this == WitcheryEquipmentItems.ICY_SLIPPERS ? 7842303 : (this == WitcheryEquipmentItems.SEEPING_SHOES ? 0x226633 : (this == WitcheryEquipmentItems.BARK_BELT ? 6968628 : 2628115));
        }
        return color2;
    }

    public boolean isHatWorn(EntityPlayer player) {
        return player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).getItem() == this;
    }

    public boolean isRobeWorn(EntityPlayer player) {
        return player.getItemStackFromSlot(EntityEquipmentSlot.CHEST).getItem() == this;
    }

    public boolean isBeltWorn(EntityPlayer player) {
        return player.getItemStackFromSlot(EntityEquipmentSlot.LEGS).getItem() == this;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelWitchesClothes(0.61f, false);
        }
        if (this.modelNecroChest == null) {
            this.modelNecroChest = new ModelWitchesClothes(0.61f, true);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelWitchesClothes(0.45f, false);
        }
        return armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.FEET ? (stack.getItem() == WitcheryEquipmentItems.NECROMANCERS_ROBES ? this.modelNecroChest : this.modelClothesChest) : this.modelClothesLegs;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        if (stack.isEmpty()) {
            return EnumRarity.COMMON;
        }
        if (stack.getItem() == WitcheryEquipmentItems.BABAS_HAT) {
            return EnumRarity.EPIC;
        }
        if (stack.getItem() == WitcheryEquipmentItems.BARK_BELT) {
            return EnumRarity.RARE;
        }
        return EnumRarity.UNCOMMON;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return super.getItemStackDisplayName(stack);
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
        if (stack.hasTagCompound()) {
            WitcheryUtils.addGoldenTooltips(PotionUtils.getEffectsFromStack((ItemStack)stack), list2);
        }
    }

    public boolean trySayTheresNoPlaceLikeHome(EntityPlayer player, String message) {
        NBTTagCompound nbtPlayer;
        ItemStack stack;
        if (player == null || player.world.isRemote) {
            return false;
        }
        if (noPlaceLikeHome == null) {
            noPlaceLikeHome = WitcheryResurrected.translate("rite.witchery.no_place_like_home", new Object[0]).toLowerCase().replace("'", "");
        }
        if (message.toLowerCase().replace("'", "").startsWith(noPlaceLikeHome) && !(stack = player.getItemStackFromSlot(EntityEquipmentSlot.FEET)).isEmpty() && stack.getItem() == WitcheryEquipmentItems.RUBY_SLIPPERS && !WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && (nbtPlayer = player.getEntityData()) != null) {
            int R = 3;
            AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)R, player.posY - (double)R, player.posZ - (double)R, player.posX + (double)R, player.posY + (double)R, player.posZ + (double)R);
            List list2 = player.world.getEntitiesWithinAABB(EntityItem.class, bounds);
            for (EntityItem waystoneEntity : list2) {
                int waystoneDimension;
                ItemStack waystoneStack = waystoneEntity.getItem();
                if (waystoneStack.getItem() != WitcheryIngredientItems.BOUND_WAYSTONE) continue;
                if (nbtPlayer.hasKey("WitcheryLastRubySlipperWayTime")) {
                    long COOLDOWN;
                    long lastTime = nbtPlayer.getLong("WitcheryLastRubySlipperWayTime");
                    long currentTime = MinecraftServer.getCurrentTimeMillis();
                    long timeSince = currentTime - lastTime;
                    if (timeSince < (COOLDOWN = 60000L)) {
                        int cooldownRemaining = Math.max(1, (int)(COOLDOWN - timeSince) / 60000);
                        player.sendMessage(new TextComponentTranslation("rite.witchery.slipper_cooldown", new Object[]{cooldownRemaining}).setStyle(new Style().setColor(TextFormatting.RED)));
                        return true;
                    }
                }
                if (Infusion.acquireEnergy(player.world, player, (waystoneDimension = WitcheryIngredientItem.getWaystoneDimension(waystoneStack)) != player.dimension ? 80 : 40, true)) {
                    waystoneEntity.setDead();
                    nbtPlayer.setLong("WitcheryLastRubySlipperWayTime", MinecraftServer.getCurrentTimeMillis());
                    if (player.world.rand.nextDouble() < 0.01) {
                        BlockVoidBramble.teleportRandomly(player.world, player.getPosition(), (Entity)player, 500);
                    } else {
                        WitcheryIngredientItem.teleportToLocation(player.world, waystoneStack, (Entity)player, 2, true);
                    }
                }
                return true;
            }
            if (nbtPlayer.hasKey("WitcheryLastRubySlipperTime")) {
                long COOLDOWN;
                long lastTime2 = nbtPlayer.getLong("WitcheryLastRubySlipperTime");
                long currentTime2 = MinecraftServer.getCurrentTimeMillis();
                long timeSince2 = currentTime2 - lastTime2;
                if (timeSince2 < (COOLDOWN = 1800000L) && !player.capabilities.isCreativeMode) {
                    int cooldownRemaining2 = Math.max(1, (int)(COOLDOWN - timeSince2) / 60000);
                    player.sendMessage(new TextComponentTranslation("rite.witchery.slipper_cooldown", new Object[]{cooldownRemaining2}).setStyle(new Style().setColor(TextFormatting.RED)));
                    return true;
                }
            }
            BlockPos coords = player.getBedLocation(player.dimension);
            int dimension = player.dimension;
            World world = player.world;
            if (coords == null) {
                coords = player.getBedLocation(0);
                dimension = 0;
                world = world.getMinecraftServer().getWorld(0);
                if (coords == null) {
                    coords = world.getSpawnPoint();
                    while (world.getBlockState(coords).isNormalCube() && coords.getY() < 255) {
                        coords = coords.up();
                    }
                }
            }
            if (coords != null) {
                nbtPlayer.setLong("WitcheryLastRubySlipperTime", MinecraftServer.getCurrentTimeMillis());
                coords = Blocks.BED.getBedSpawnPosition(world.getBlockState(coords), (IBlockAccess)world, coords, null);
                if (coords != null) {
                    if (Infusion.acquireEnergy(player.world, player, dimension != player.dimension ? 120 : 80, true)) {
                        WitcheryIngredientItem.teleportToLocation(coords.up(), dimension, (Entity)player, true);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

