/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\bH\u0016\u00a8\u0006\u001e"}, d2={"Lnet/msrandom/witchery/item/ItemWitchHand;", "Lnet/minecraft/item/Item;", "()V", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "itemstack", "Lnet/minecraft/item/ItemStack;", "getMaxItemUseDuration", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "worldIn", "Lnet/minecraft/world/World;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "handIn", "Lnet/minecraft/util/EnumHand;", "onLeftClickEntity", "", "player", "entity", "Lnet/minecraft/entity/Entity;", "onPlayerStoppedUsing", "", "world", "Lnet/minecraft/entity/EntityLivingBase;", "countdown", "onUsingTick", "stack", "count", "WitcheryResurrected"})
public final class ItemWitchHand
extends Item {
    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack itemstack) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        return EnumRarity.UNCOMMON;
    }

    public boolean onLeftClickEntity(@NotNull ItemStack itemstack, @NotNull EntityPlayer player, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        WitcheryUtils.getExtension((EntityPlayer)player).infusionPower.getInfusionType().onLeftClickEntity(player.world, player, entity);
        return true;
    }

    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)handIn, (String)"handIn");
        playerIn.setActiveHand(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.getHeldItem(handIn));
    }

    public int getMaxItemUseDuration(@NotNull ItemStack itemstack) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        return 400;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int count) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (player instanceof EntityPlayer) {
            WitcheryUtils.getExtension((EntityPlayer)((EntityPlayer)player)).infusionPower.getInfusionType().onUsingItemTick(player.world, (EntityPlayer)player, count);
        }
    }

    public void onPlayerStoppedUsing(@NotNull ItemStack itemstack, @NotNull World world, @NotNull EntityLivingBase player, int countdown) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (player instanceof EntityPlayer && (world.isRemote || !Infusion.isOnCooldown(world, itemstack))) {
            WitcheryUtils.getExtension((EntityPlayer)((EntityPlayer)player)).infusionPower.getInfusionType().onPlayerStoppedUsing(itemstack, world, (EntityPlayer)player, countdown);
        }
    }

    public ItemWitchHand() {
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setMaxStackSize(1);
        this.setFull3D();
    }
}

