/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.renderer.entity.model.FeminineVampireArmor;
import net.msrandom.witchery.client.renderer.entity.model.MasculineVampireArmor;
import net.msrandom.witchery.client.renderer.entity.model.MetallicVampireArmor;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.traits.Invisible;

public class ItemVampireClothes
extends ItemArmor
implements ISpecialArmor,
Invisible {
    private final Type type;
    private final int realDamageReduction;

    public ItemVampireClothes(EntityEquipmentSlot armorSlot, Type type) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.type = type;
        this.setMaxDamage(ItemArmor.ArmorMaterial.IRON.getDurability(armorSlot));
        this.realDamageReduction = type == Type.METAL ? ItemArmor.ArmorMaterial.IRON.getDamageReductionAmount(armorSlot) : this.damageReduceAmount;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static int numLightPiecesWorn(EntityLivingBase entity, boolean light) {
        int pieces = 0;
        for (int i = 2; i <= 5; ++i) {
            ItemStack item = entity.getItemStackFromSlot(EntityEquipmentSlot.values()[i]);
            if (!(item.getItem() instanceof ItemVampireClothes) || ((ItemVampireClothes)item.getItem()).type == Type.METAL || !light) continue;
            ++pieces;
        }
        return pieces;
    }

    public static boolean isFlameProtectionActive(EntityLivingBase entity) {
        return ItemVampireClothes.numLightPiecesWorn(entity, true) >= 3 || ItemVampireClothes.numLightPiecesWorn(entity, true) >= 2;
    }

    public static boolean isExtendedFlameProtectionActive(EntityLivingBase entity) {
        return ItemVampireClothes.numLightPiecesWorn(entity, true) >= 4;
    }

    public static boolean isDrinkBoostActive(EntityLivingBase entity) {
        return ItemVampireClothes.numLightPiecesWorn(entity, true) >= 2;
    }

    public static boolean isMesmeriseBoostActive(EntityLivingBase entity) {
        return ItemVampireClothes.numLightPiecesWorn(entity, true) >= 3;
    }

    public int getItemEnchantability() {
        return ItemArmor.ArmorMaterial.GOLD.getEnchantability();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String textureName;
        switch (this.type) {
            case MASCULINE: {
                textureName = MasculineVampireArmor.SET.getTexture(slot, entity);
                break;
            }
            case FEMININE: {
                textureName = FeminineVampireArmor.SET.getTexture(slot, entity);
                break;
            }
            default: {
                textureName = "metallic_" + (slot == EntityEquipmentSlot.LEGS ? "legs" : "body");
            }
        }
        return "witchery:textures/entity/vampire_armor/" + textureName + ".png";
    }

    public boolean hasColor(ItemStack stack) {
        return true;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return super.getColor(stack);
        }
        int color2 = super.getColor(stack);
        if (color2 == 10511680) {
            color2 = 0xCC0000;
        }
        return color2;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        switch (this.type) {
            case MASCULINE: {
                return MasculineVampireArmor.SET.getModel(entityLiving);
            }
            case FEMININE: {
                return FeminineVampireArmor.SET.getModel(entityLiving);
            }
        }
        return MetallicVampireArmor.INSTANCE;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return super.getItemStackDisplayName(stack);
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)this.realDamageReduction / 25.0, armor.getMaxDamage() + 1 - armor.getItemDamage());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.realDamageReduction;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.damageItem(damage, entity);
    }

    public static enum Type {
        MASCULINE,
        FEMININE,
        METAL;

    }
}

