/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.block.BlockCrystalBall;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityEye;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntityTreefyd;
import net.msrandom.witchery.entity.EntityWingedMonkey;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.BloodStorage;
import net.msrandom.witchery.network.PacketEyePosition;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemTaglockKit
extends Item
implements BloodStorage {
    private final boolean bound;

    public ItemTaglockKit(boolean bound) {
        this.bound = bound;
        if (!bound) {
            this.setCreativeTab(WitcheryGeneralItems.TAB);
        }
        this.setMaxStackSize(16);
    }

    public static boolean isTaglockRestricted(EntityPlayer collector, EntityLivingBase target) {
        if (!(target instanceof EntityPlayer) || collector.equals((Object)target)) {
            return false;
        }
        if (WitcheryConfigOptions.restrictTaglockCollectionOnNonPVPServers && !collector.getServer().isPVPEnabled()) {
            return true;
        }
        EntityPlayer targetPlayer = (EntityPlayer)target;
        return WitcheryConfigOptions.restrictTaglockCollectionForStaffMembers && targetPlayer.getServer().getPlayerList().canSendCommands(targetPlayer.getGameProfile());
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
        super.addInformation(stack, worldIn, list2, advTooltips);
        if (this.bound) {
            ITextComponent bound = ItemTaglockKit.getBoundEntityName(stack, 0);
            if (bound != null) {
                list2.add(bound.setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)).getFormattedText());
            }
        } else {
            list2.add(I18n.format((String)(this.getTranslationKey() + ".unbound"), (Object[])new Object[0]));
        }
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1200;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase livingBase, int countdown) {
        if (livingBase instanceof EntityPlayerMP) {
            EntityLivingBase entity;
            EntityPlayerMP player = (EntityPlayerMP)livingBase;
            World world = player.world;
            int elapsedTicks = this.getMaxItemUseDuration(stack) - countdown;
            if (elapsedTicks % 20 == 0 && (entity = ItemTaglockKit.getBoundEntity(world, stack, 0)) != null && entity.dimension == player.dimension) {
                if (entity == player) {
                    if (elapsedTicks == 0) {
                        EntityEye eye = new EntityEye(world);
                        eye.setLocationAndAngles(player.posX, player.posY, player.posZ, player.rotationYaw, 90.0f);
                        world.spawnEntity((Entity)eye);
                        WitcheryNetworkChannel.sendTo(new PacketEyePosition((Entity)eye, true), player);
                    }
                } else {
                    WitcheryNetworkChannel.sendTo(new PacketEyePosition((Entity)entity, elapsedTicks == 0), player);
                }
            }
        }
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ItemStack onItemUseFinish(ItemStack stack, World world, EntityLivingBase player) {
        if (player instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketEyePosition(null, true), (EntityPlayerMP)player);
        }
        return stack;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (player instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketEyePosition(null, true), (EntityPlayerMP)player);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack itemstack = player.getHeldItem(hand);
        if (block == Blocks.BED || block instanceof BlockCoffin || block.getTranslationKey().equals("tile.blockCarpentersBed") || block.isBed(state, (IBlockAccess)world, pos, (Entity)player)) {
            if (block == Blocks.BED && state.getValue((IProperty)BlockBed.PART) != BlockBed.EnumPartType.HEAD && world.getBlockState(pos = pos.offset((EnumFacing)state.getValue((IProperty)BlockBed.FACING))).getBlock() != Blocks.BED) {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                return !world.isRemote ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            if (player.isSneaking()) {
                if (!world.isRemote) {
                    this.setPlayerTaglock(world, player, itemstack, player, hand);
                }
                return !world.isRemote ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            if (!world.isRemote) {
                boolean taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos, hand);
                if (!taglockSaved && block != Blocks.BED) {
                    if (world.getBlockState(pos.east()).getBlock() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.east(), hand);
                    }
                    if (!taglockSaved && world.getBlockState(pos.south()).getBlock() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.south(), hand);
                    }
                    if (!taglockSaved && world.getBlockState(pos.west()).getBlock() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.west(), hand);
                    }
                    if (!taglockSaved && world.getBlockState(pos.north()).getBlock() == block) {
                        taglockSaved = this.tryBindTaglockFromBed(itemstack, player, world, pos.north(), hand);
                    }
                }
                if (taglockSaved) {
                    return EnumActionResult.SUCCESS;
                }
            }
            if (!world.isRemote) {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
            return !world.isRemote ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        if (block == WitcheryBlocks.CRYSTAL_BALL) {
            if (this.bound) {
                if (!world.isRemote && BlockCrystalBall.tryConsumePower(world, player, pos)) {
                    player.setActiveHand(hand);
                } else if (world.isRemote) {
                    player.setActiveHand(hand);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
            return !world.isRemote ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    private boolean tryBindTaglockFromBed(ItemStack itemstack, EntityPlayer player, World world, BlockPos clickedBedLocation, EnumHand hand) {
        String boundName = "";
        EntityLivingBase boundEntity = ItemTaglockKit.getBoundEntity(world, itemstack, 0);
        if (boundEntity instanceof EntityPlayer) {
            boundName = boundEntity.getName();
        }
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (EntityPlayer worldPlayer : world.playerEntities) {
            BlockPos playerBedLocation = worldPlayer.getBedLocation(player.dimension);
            if (playerBedLocation == null || !playerBedLocation.equals((Object)clickedBedLocation)) continue;
            players.add(worldPlayer);
        }
        players.sort(Comparator.comparing(EntityPlayer::getName));
        boolean taglockSaved = false;
        if (players.size() > 0) {
            if (boundName.isEmpty()) {
                taglockSaved = this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand);
            } else {
                boolean found = false;
                for (int i = 0; i < players.size() && !found; ++i) {
                    if (!((EntityPlayer)players.get(i)).getName().equals(boundName)) continue;
                    taglockSaved = i == players.size() - 1 ? this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand) : this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(i + 1), hand);
                    found = true;
                }
                if (!found) {
                    taglockSaved = this.setPlayerTaglock(world, player, itemstack, (EntityPlayer)players.get(0), hand);
                }
            }
        }
        return taglockSaved;
    }

    private boolean setPlayerTaglock(World world, EntityPlayer player, ItemStack itemstack, EntityPlayer victim, EnumHand hand) {
        if (!ItemTaglockKit.isTaglockRestricted(player, (EntityLivingBase)victim)) {
            ItemTaglockKit.setEntityTaglock(world, player, itemstack, (Entity)victim, hand);
            return true;
        }
        return false;
    }

    public static void setEntityTaglock(World world, EntityPlayer player, ItemStack itemstack, UUID victim, EnumHand hand) {
        Entity entity;
        if (!world.isRemote && (entity = ((WorldServer)world).getEntityFromUuid(victim)) != null) {
            ItemTaglockKit.setEntityTaglock(world, player, itemstack, entity, hand);
        }
    }

    public static void setEntityTaglock(World world, EntityPlayer player, ItemStack itemstack, Entity victim, EnumHand hand) {
        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.BOUND_TAGLOCK_KIT);
        WitcheryGeneralItems.BOUND_TAGLOCK_KIT.updateBloodOwner(newStack, victim, 0);
        WitcheryUtils.playSoundAt(player, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.world.rand.nextDouble() * 0.4f + 0.8f));
        if (itemstack.getCount() == 1) {
            player.setHeldItem(hand, newStack);
        } else {
            itemstack.shrink(1);
            if (!player.inventory.addItemStackToInventory(newStack)) {
                player.dropItem(newStack, false);
            }
        }
    }

    public static void onEntityInteract(World world, EntityPlayer player, ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        if (!world.isRemote && stack.getItem() instanceof ItemTaglockKit && event.getTarget() != null && event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            if (!(target instanceof EntityPlayer) || ItemTaglockKit.isSneakSuccessful(player, target)) {
                if (target instanceof EntityTreefyd || target instanceof EntityImp || target instanceof EntityWingedMonkey && !player.isSneaking()) {
                    return;
                }
                ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.BOUND_TAGLOCK_KIT);
                ItemTaglockKit.setEntityTaglock(newStack, player, (Entity)target, true, 0);
                if (stack.getCount() == 1) {
                    player.setHeldItem(event.getHand(), newStack);
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                    }
                } else {
                    stack.shrink(1);
                    if (!player.inventory.addItemStackToInventory(newStack)) {
                        world.spawnEntity((Entity)new EntityItem(world, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                    } else if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                    }
                }
            } else {
                event.getEntityPlayer().sendMessage(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.getTranslationKey() + ".player_noticed_taglock", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                target.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.getTranslationKey() + ".noticed_taglock", new Object[0]).setStyle(new Style().setColor(TextFormatting.GREEN)));
            }
            event.setCanceled(true);
        }
    }

    private static boolean isSneakSuccessful(EntityPlayer sneaker, EntityLivingBase target) {
        double chance;
        double targetFacing;
        if (ItemTaglockKit.isTaglockRestricted(sneaker, target)) {
            return false;
        }
        double sneakerFacing = (sneaker.rotationYawHead + 90.0f) % 360.0f;
        if (sneakerFacing < 0.0) {
            sneakerFacing += 360.0;
        }
        if ((targetFacing = (double)((target.rotationYawHead + 90.0f) % 360.0f)) < 0.0) {
            targetFacing += 360.0;
        }
        double ARC = 45.0;
        double diff = Math.abs(targetFacing - sneakerFacing);
        double d = chance = sneaker.isInvisible() ? 0.11 : 0.01;
        if (360.0 - diff % 360.0 < ARC || diff % 360.0 < ARC) {
            chance = sneaker.isSneaking() ? 0.6 : 0.3;
        }
        return sneaker.world.rand.nextDouble() < chance;
    }

    public static void setEntityTaglock(ItemStack stack, EntityPlayer player, Entity entity, boolean playSoundAtPlayer, int index) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        ((BloodStorage)stack.getItem()).updateBloodOwner(stack, entity, index);
        if (playSoundAtPlayer) {
            WitcheryUtils.playSoundAt(player, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
        }
    }

    public static void clearTaglock(ItemStack stack, int index) {
        if (!stack.isEmpty()) {
            ((BloodStorage)stack.getItem()).clearBlood(stack, index);
        }
    }

    public static boolean isTaglockPresent(ItemStack stack, int index) {
        return ((BloodStorage)stack.getItem()).hasBlood(stack, index);
    }

    public static ITextComponent getBoundEntityName(ItemStack stack, int index) {
        return ((BloodStorage)stack.getItem()).getBloodName(stack, index);
    }

    public static Class<? extends Entity> getBoundEntityType(ItemStack stack, int index) {
        return ((BloodStorage)stack.getItem()).getEntityType(stack, index);
    }

    public static UUID getBoundCreatureID(ItemStack stack, int index) {
        if (stack.hasTagCompound()) {
            return stack.getTagCompound().getTagList("Blood", 10).getCompoundTagAt(index).getUniqueId("ID");
        }
        return new UUID(0L, 0L);
    }

    public static void bindTaglock(ItemStack stackTaglockKit, ItemStack stackPoppet, int index) {
        NBTTagCompound taglock = stackTaglockKit.getTagCompound().getTagList("Blood", 10).getCompoundTagAt(0);
        ((BloodStorage)stackPoppet.getItem()).updateBloodOwner(stackPoppet, taglock.getUniqueId("ID"), taglock.getString("Type"), taglock.hasKey("Name") ? taglock.getString("Name") : null, index);
    }

    public static boolean containsTaglockForEntity(ItemStack stack, Entity entity, int index) {
        BloodStorage storage;
        if (stack.hasTagCompound() && (storage = (BloodStorage)stack.getItem()).hasBlood(stack, index)) {
            return entity.getUniqueID().equals(stack.getTagCompound().getTagList("Blood", 10).getCompoundTagAt(index).getUniqueId("ID"));
        }
        return false;
    }

    public static EntityLivingBase getBoundEntity(World world, ItemStack stack, int index) {
        BloodStorage storage = (BloodStorage)stack.getItem();
        if (storage.hasBlood(stack, index)) {
            UUID uniqueId = stack.getTagCompound().getTagList("Blood", 10).getCompoundTagAt(index).getUniqueId("ID");
            if (!world.isRemote) {
                MinecraftServer server = world.getMinecraftServer();
                for (WorldServer worldServer : server.worlds) {
                    Entity entity = worldServer.getEntityFromUuid(uniqueId);
                    if (!(entity instanceof EntityLivingBase)) continue;
                    return (EntityLivingBase)entity;
                }
            } else {
                return world.getPlayerEntityByUUID(uniqueId);
            }
        }
        return null;
    }
}

