/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.item.ItemBrewBottle;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/item/ItemSplashBrewPotion;", "Lnet/msrandom/witchery/item/ItemBrewBottle;", "()V", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "stack", "Lnet/minecraft/item/ItemStack;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "WitcheryResurrected"})
public final class ItemSplashBrewPotion
extends ItemBrewBottle {
    @Override
    @NotNull
    public EnumAction getItemUseAction(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumAction.BOW;
    }

    @Override
    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = player.getHeldItem(hand);
        if (!player.capabilities.isCreativeMode) {
            stack.shrink(1);
        }
        world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        if (!world.isRemote) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            EntityLivingBase entityLivingBase = (EntityLivingBase)player;
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            EntityBrew brew = new EntityBrew(world, entityLivingBase, itemStack, false);
            brew.shoot((Entity)player, player.rotationPitch, player.rotationYaw, -20.0f, 0.75f, (float)(100 - playerEx.increaseThrowingSkill()) / 100.0f);
            world.spawnEntity((Entity)brew);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

