/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityBanshee;
import net.msrandom.witchery.entity.EntityPoltergeist;
import net.msrandom.witchery.entity.EntitySpectre;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemSpectralStone
extends Item {
    public ItemSpectralStone() {
        this.setMaxStackSize(16);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static ItemStack makeStack(Class<? extends EntityCreature> entityType, int count) {
        ItemStack stack = new ItemStack((Item)WitcheryGeneralItems.SPECTRAL_STONE);
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("Type", EntityList.getKey(entityType).toString());
        tag.setInteger("Quantity", Math.min(count, 7));
        stack.setTagCompound(tag);
        return stack;
    }

    private EntityType<?> getType(ItemStack stack) {
        return stack.hasTagCompound() ? RegistryWrappers.ENTITIES.get(new ResourceLocation(WitcheryUtils.getOrCreateTag(stack).getString("Type"))) : null;
    }

    private int getQuantityFromStack(ItemStack stack) {
        return stack.hasTagCompound() ? WitcheryUtils.getOrCreateTag(stack).getInteger("Quantity") : 0;
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.getSubItems(tab, items);
        if (this.isInCreativeTab(tab)) {
            items.add((Object)ItemSpectralStone.makeStack(EntitySpectre.class, 1));
            items.add((Object)ItemSpectralStone.makeStack(EntityBanshee.class, 1));
            items.add((Object)ItemSpectralStone.makeStack(EntityPoltergeist.class, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag extraTip) {
        EntityType<?> type = this.getType(stack);
        if (type != null) {
            int quantity = Math.min(this.getQuantityFromStack(stack), 4);
            EntityEntry entry2 = EntityRegistry.getEntry(type.getEntityClass());
            if (entry2 != null) {
                list2.add(I18n.format((String)("entity." + entry2.getName() + ".name"), (Object[])new Object[0]) + ": " + quantity);
            }
        }
    }

    public boolean hasEffect(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 400;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int countdown) {
        int elapsedTicks = this.getMaxItemUseDuration(stack) - countdown;
        if (player instanceof EntityPlayer && elapsedTicks == 40) {
            WitcheryUtils.playSoundAt((EntityPlayer)player, SoundEvents.BLOCK_NOTE_PLING, SoundCategory.PLAYERS, 0.5f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase entityLiving, int countdown) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int elapsedTicks = this.getMaxItemUseDuration(stack) - countdown;
            int quantity = Math.min(this.getQuantityFromStack(stack), 3);
            EntityType<?> type = this.getType(stack);
            if (type == null) {
                if (world.isRemote) {
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else if (elapsedTicks >= 40 && quantity > 0) {
                RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, player, true, 16.0);
                BlockPos coords = BlockUtil.getBlockCoords(world, mop, true);
                if (coords != null) {
                    if (!world.isRemote) {
                        for (int i = 0; i < quantity; ++i) {
                            int ax = world.rand.nextInt(3);
                            int az = world.rand.nextInt(3);
                            BlockPos pos = world.getHeight(coords.add(ax - 1, 8, az - 1));
                            Object entity = type.create(world);
                            if (entity == null) continue;
                            if (entity instanceof EntityLiving) {
                                EntityLiving living = (EntityLiving)entity;
                                living.onInitialSpawn(((Entity)entity).world.getDifficultyForLocation(entity.getPosition()), null);
                                living.enablePersistence();
                                PotionEnslaved.setEnslaverForMob(living, player);
                                if (living instanceof EntityTameable) {
                                    ((EntityTameable)living).setOwnerId(player.getUniqueID());
                                    ((EntityTameable)living).setTamed(true);
                                } else if (entity instanceof EntitySummonedUndead) {
                                    ((EntitySummonedUndead)((Object)entity)).setSummoner(player.getUniqueID());
                                }
                            }
                            entity.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 1.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                            world.spawnEntity(entity);
                            WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_INSTANT, (double)pos.getX() + 0.5, (double)pos.getY() + 1.05, (double)pos.getZ() + 0.5, 0.0, 20);
                        }
                    }
                    if (!player.capabilities.isCreativeMode) {
                        if (stack.getCount() > 1) {
                            ItemStack newStack = stack.splitStack(1);
                            newStack.setItemDamage(0);
                            if (!player.inventory.addItemStackToInventory(newStack)) {
                                if (!world.isRemote) {
                                    world.spawnEntity((Entity)new EntityItem(world, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                                }
                            } else if (player instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                            }
                        } else {
                            stack.setItemDamage(0);
                        }
                    }
                } else {
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }
}

