/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.rite.curse.Curse;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/item/ItemSeerStone;", "Lnet/minecraft/item/Item;", "()V", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "stack", "Lnet/minecraft/item/ItemStack;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "getMaxItemUseDuration", "", "hasEffect", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onUsingTick", "", "Lnet/minecraft/entity/EntityLivingBase;", "count", "readPlayer", "targetPlayer", "WitcheryResurrected"})
public final class ItemSeerStone
extends Item {
    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking()) {
            if (!world.isRemote) {
                RayTraceResult hit = OtherwhereInfusion.doCustomRayTrace(world, player, true, 3.0);
                if (hit != null && hit.typeOfHit == RayTraceResult.Type.ENTITY) {
                    Entity entity = hit.entityHit;
                    if (entity instanceof EntityPlayer) {
                        ItemStack itemStack = stack;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                        this.readPlayer(itemStack, player, (EntityPlayer)entity);
                        player.getCooldownTracker().setCooldown((Item)this, 10);
                    }
                } else {
                    ItemStack itemStack = stack;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                    this.readPlayer(itemStack, player, player);
                    player.getCooldownTracker().setCooldown((Item)this, 10);
                }
            }
        } else {
            player.setActiveHand(hand);
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"ActionResult.newResult(E\u2026ionResult.SUCCESS, stack)");
        return actionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int count) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        World world = player.world;
        if (!world.isRemote && player instanceof EntityPlayer) {
            World world2 = world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
            EntityPlayer entityPlayer = (EntityPlayer)player;
            BlockPos blockPos = player.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"player.getPosition()");
            EntityCovenWitch.Companion.summonCoven(world2, entityPlayer, blockPos, stack.getMaxItemUseDuration() - count);
        }
    }

    public int getMaxItemUseDuration(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 1200;
    }

    @NotNull
    public EnumAction getItemUseAction(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumAction.BOW;
    }

    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumRarity.UNCOMMON;
    }

    public boolean hasEffect(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final void readPlayer(ItemStack stack, EntityPlayer player, EntityPlayer targetPlayer) {
        livingEx = WitcheryDataExtensions.LIVING.get((EntityLivingBase)((Entity)targetPlayer));
        playerEx = WitcheryUtils.getExtension(targetPlayer);
        text = new TextComponentString("");
        timeRemaining = playerEx.getSpiritData().getManifestationDuration();
        if (timeRemaining > 0) {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".can_manifest", new Object[]{timeRemaining}));
        } else {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".can_not_manifest", new Object[0]));
        }
        text.appendText("\n");
        familiarName = Familiars.getFamiliarName(targetPlayer);
        if (familiarName == null) ** GOTO lbl-1000
        var9_9 = familiarName;
        var10_11 = false;
        if (var9_9.length() > 0) {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".familiar", new Object[]{familiarName}));
        } else lbl-1000:
        // 2 sources

        {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".no_familiar", new Object[]{familiarName}));
        }
        text.appendText("\n");
        covenSize = playerEx.coven.size();
        if (covenSize > 0) {
            if (covenSize == 1) {
                text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".single_coven_witch", new Object[]{covenSize}));
            } else {
                text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".coven_size", new Object[]{covenSize}));
            }
        } else {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".no_coven", new Object[0]));
        }
        text.appendText("\n");
        spellKnowledge = SymbolEffect.Companion.getKnowledge(targetPlayer);
        if (spellKnowledge != null) {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".known_spells", new Object[]{spellKnowledge}));
        } else {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".no_spells", new Object[0]));
        }
        text.appendText("\n").appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".bottling_skill", new Object[]{playerEx.getBottlingSkill()})).appendText("\n").appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".throwing_skill", new Object[]{playerEx.getThrowingSkill()})).appendText("\n");
        curseCount = 0;
        curses = new TextComponentString("");
        var14_15 = Curse.REGISTRY.iterator();
        while (var14_15.hasNext()) {
            var17_19 = var13_16 = var14_15.next();
            var18_20 = false;
            var15_17 = (ResourceLocation)var17_19.getKey();
            var17_19 = var13_16;
            var18_20 = false;
            value = (Curse)var17_19.getValue();
            if (!livingEx.getCurses().containsKey((Object)value)) continue;
            if (curseCount > 0) {
                curses.appendText(", ");
            }
            curses.appendSibling((ITextComponent)new TextComponentTranslation("curse." + key.getNamespace() + '.' + key.getPath(), new Object[0]));
            curses.appendText(" (" + livingEx.getCurses().getInt((Object)value) + ")");
            ++curseCount;
        }
        if (curseCount > 0) {
            text.appendSibling((ITextComponent)curses);
        } else {
            text.appendSibling((ITextComponent)new TextComponentTranslation(stack.getTranslationKey() + ".no_curses", new Object[0]));
        }
        player.sendMessage(text.setStyle(new Style().setColor(TextFormatting.BLUE)));
    }

    public ItemSeerStone() {
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }
}

