/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.item.EntityQuartzGrenade;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemQuartzGrenade
extends Item {
    public static final Map<UUID, String> NAME_CACHE = new HashMap<UUID, String>();
    public final int mode;

    public ItemQuartzGrenade(int mode) {
        this.mode = mode;
        this.setMaxStackSize(16);
        this.setMaxDamage(0);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static UUID getOwnerId(ItemStack stack) {
        if (stack.hasTagCompound()) {
            NBTTagCompound nbtRoot = stack.getTagCompound();
            return nbtRoot.getUniqueId("Owner");
        }
        return null;
    }

    public static void setOwnerName(ItemStack stack, UUID id) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setUniqueId("Owner", id);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag moreTips) {
        super.addInformation(stack, world, tooltip, moreTips);
        if (this.mode == 1) {
            UUID boundPlayer = ItemQuartzGrenade.getOwnerId(stack);
            if (world != null && boundPlayer != null) {
                EntityPlayer player;
                String name2 = NAME_CACHE.get(boundPlayer);
                if (name2 == null && (player = world.getPlayerEntityByUUID(boundPlayer)) != null) {
                    name2 = player.getName();
                    NAME_CACHE.put(boundPlayer, name2);
                }
                if (name2 != null) {
                    tooltip.add(I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[]{name2}));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack) {
        return true;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (!player.capabilities.isCreativeMode) {
            stack.shrink(1);
        }
        world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, player.getSoundCategory(), 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isRemote) {
            EntityQuartzGrenade grenade = new EntityQuartzGrenade(world, (EntityLivingBase)player);
            grenade.shoot((Entity)player, player.rotationPitch, player.rotationYaw, -20.0f, 0.75f, 1.0f);
            grenade.setMode(this.mode);
            if (this.mode == 1) {
                grenade.setOwnerId(ItemQuartzGrenade.getOwnerId(stack));
            }
            world.spawnEntity((Entity)grenade);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

