/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/item/ItemPurifiedMilk;", "Lnet/minecraft/item/Item;", "()V", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "stack", "Lnet/minecraft/item/ItemStack;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "getMaxItemUseDuration", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "worldIn", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUseFinish", "world", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "WitcheryResurrected"})
public final class ItemPurifiedMilk
extends Item {
    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumRarity.UNCOMMON;
    }

    @NotNull
    public EnumAction getItemUseAction(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumAction.DRINK;
    }

    public int getMaxItemUseDuration(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 32;
    }

    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World worldIn, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        player.setActiveHand(hand);
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"ActionResult.newResult(E\u2026player.getHeldItem(hand))");
        return actionResult;
    }

    @NotNull
    public ItemStack onItemUseFinish(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entityLiving) {
        block7: {
            EntityPlayer player;
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)entityLiving, (String)"entityLiving");
            EntityLivingBase entityLivingBase = entityLiving;
            if (!(entityLivingBase instanceof EntityPlayer)) {
                entityLivingBase = null;
            }
            if ((player = (EntityPlayer)entityLivingBase) == null || !player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.CONSUME_ITEM.trigger((EntityPlayerMP)player, stack);
                player.addStat(StatList.getObjectUseStats((Item)this));
                if (world.rand.nextBoolean()) {
                    Collection effects2;
                    Collection collection = effects2 = player.getActivePotionEffects();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"effects");
                    Collection collection2 = collection;
                    boolean bl = false;
                    if (!collection2.isEmpty()) {
                        Object object = CollectionsKt.elementAt((Iterable)effects2, (int)world.rand.nextInt(effects2.size()));
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"effects.elementAt(world.\u2026nd.nextInt(effects.size))");
                        player.removePotionEffect(((PotionEffect)object).getPotion());
                    }
                }
            }
            if (player != null && player.capabilities.isCreativeMode) break block7;
            if (stack.isEmpty()) {
                return new ItemStack(WitcheryFumeItems.CLAY_JAR);
            }
            EntityPlayer entityPlayer = player;
            if (entityPlayer != null && (entityPlayer = entityPlayer.inventory) != null) {
                entityPlayer.addItemStackToInventory(new ItemStack(WitcheryFumeItems.CLAY_JAR));
            }
        }
        return stack;
    }
}

