/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntitySpectralFamiliar;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class ItemPolynesiaCharm
extends Item {
    private final boolean charmDemons;

    public ItemPolynesiaCharm(boolean charmDemons) {
        this.charmDemons = charmDemons;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setMaxDamage(50);
        this.setMaxStackSize(1);
    }

    public static boolean hasStockInventory(EntityLiving entity) {
        if (entity == null) {
            return false;
        }
        NBTTagCompound nbtTag = entity.getEntityData();
        return nbtTag.hasKey("WitcheryShopStock");
    }

    public static void setEmptyStockInventory(World world, EntityLiving entity) {
        if (entity != null && !world.isRemote) {
            NBTTagCompound nbtTag = entity.getEntityData();
            nbtTag.setTag("WitcheryShopStock", (NBTBase)new NBTTagCompound());
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (!world.isRemote) {
            EntityLiving living;
            boolean success = false;
            RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, player, true, 5.0);
            if (mop != null && mop.typeOfHit == RayTraceResult.Type.ENTITY && mop.entityHit instanceof EntityLiving && ((living = (EntityLiving)mop.entityHit) instanceof EntityAnimal || living instanceof EntityAmbientCreature || living instanceof EntitySpider || living instanceof EntityWaterMob || living instanceof EntityCreeper && WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player) || living.isEntityUndead() && WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) && !(living instanceof EntitySpectralFamiliar) && !(living instanceof EntityCovenWitch) && !(living instanceof EntityImp) && living.isEntityAlive() && !living.isChild() && living.getAttackTarget() == null && (!(living instanceof EntityBat) || this.canBatDrop(living))) {
                AnimalMerchant merchant = new AnimalMerchant(living);
                merchant.playIntro();
                merchant.setCustomer(player);
                player.displayVillagerTradeGui((IMerchant)merchant);
                success = true;
            }
            if (!success || mop.entityHit instanceof EntityDemon) {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            } else {
                player.getHeldItem(hand).damageItem(1, (EntityLivingBase)player);
            }
        }
        return super.onItemRightClick(world, player, hand);
    }

    private boolean canBatDrop(EntityLiving living) {
        NBTTagCompound nbtBat = living.getEntityData();
        return !nbtBat.hasKey("WitcheryNoDrops") || !nbtBat.getBoolean("WitcheryNoDrops");
    }

    public boolean canCharmDemons() {
        return this.charmDemons;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemstack, World worldIn, List<String> list2, ITooltipFlag par4) {
        for (String s : I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[0]).split("\\|")) {
            list2.add(s);
        }
    }

    private static class AnimalMerchant
    implements IMerchant {
        static final String STOCKS_KEY = "WitcheryShopStock";
        private final EntityLiving animal;
        private EntityPlayer customer;
        private MerchantRecipeList currentList = null;

        public AnimalMerchant(EntityLiving animal) {
            this.animal = animal;
        }

        private static void populateList(EntityLiving animal, MerchantRecipeList finalList) {
            Random r = animal.world.rand;
            MerchantRecipeList list2 = new MerchantRecipeList();
            ItemStack[] stacks = new ItemStack[]{new ItemStack(WitcheryIngredientItems.MANDRAKE_ROOT, 3), new ItemStack(WitcheryIngredientItems.BELLADONNA, 3), new ItemStack(WitcheryIngredientItems.ARTICHOKE, 3), new ItemStack(Blocks.SAPLING, 4, 0), new ItemStack(Blocks.SAPLING, 4, 1), new ItemStack(Blocks.SAPLING, 4, 2), new ItemStack(Blocks.SAPLING, 4, 3), new ItemStack((Block)Blocks.REEDS, 2), new ItemStack((Block)Blocks.CACTUS, 2), new ItemStack(Items.GOLD_NUGGET, 5), new ItemStack(Items.IRON_INGOT, 2), new ItemStack(Items.BONE, 4), new ItemStack(Items.FLINT, 5), new ItemStack(WitcheryIngredientItems.DOG_TONGUE, 2), new ItemStack(Items.POTATO, 5), new ItemStack(Items.POISONOUS_POTATO, 2), new ItemStack(Items.CARROT, 5), new ItemStack(Items.CLAY_BALL, 10)};
            ArrayList<ItemStack> currencies = new ArrayList<ItemStack>();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(stacks[r.nextInt(stacks.length)]);
            if (animal.world.rand.nextDouble() < 0.03) {
                items.add(new ItemStack(WitcheryIngredientItems.TREEFYD_SEEDS));
            }
            if (animal instanceof EntityPig) {
                currencies.add(new ItemStack(Items.CARROT));
                currencies.add(new ItemStack(Items.APPLE));
                currencies.add(new ItemStack(Items.POTATO));
                items.add(new ItemStack((Block)Blocks.RED_MUSHROOM, 5));
                items.add(new ItemStack((Block)Blocks.BROWN_MUSHROOM, 5));
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(Items.EMERALD, 1));
                }
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.DIAMOND, 1));
                }
            } else if (animal instanceof EntityHorse) {
                currencies.add(new ItemStack(Items.CARROT));
                currencies.add(new ItemStack(Items.APPLE));
                currencies.add(new ItemStack(Items.WHEAT));
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.SADDLE, 1));
                }
            } else if (animal instanceof EntityWolf) {
                currencies.add(new ItemStack(Items.BEEF));
                currencies.add(new ItemStack(Items.PORKCHOP));
                currencies.add(new ItemStack(Items.CHICKEN));
                items.add(new ItemStack(Items.BONE, 5));
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(Items.EMERALD, 1));
                }
                if (r.nextDouble() < 0.01) {
                    items.add(new ItemStack(Items.DIAMOND, 1));
                }
            } else if (animal instanceof EntityOcelot) {
                currencies.add(new ItemStack(Items.MILK_BUCKET));
                currencies.add(new ItemStack(Items.FISH));
            } else if (animal instanceof EntityMooshroom) {
                currencies.add(new ItemStack((Block)Blocks.RED_MUSHROOM));
                currencies.add(new ItemStack((Block)Blocks.BROWN_MUSHROOM));
            } else if (animal instanceof EntityCow) {
                currencies.add(new ItemStack(Items.WHEAT));
            } else if (animal instanceof EntityChicken) {
                currencies.add(new ItemStack(Items.WHEAT_SEEDS));
                items.add(new ItemStack(Items.FEATHER, 10));
                items.add(new ItemStack(Items.EGG, 5));
            } else if (animal instanceof EntitySheep) {
                currencies.add(new ItemStack(Items.WHEAT));
            } else if (animal instanceof EntitySquid) {
                currencies.add(new ItemStack(Items.FISH));
                items.add(new ItemStack(Items.DYE, 10, EnumDyeColor.BLACK.getDyeDamage()));
            } else if (animal instanceof EntityBat) {
                currencies.add(new ItemStack(Items.WHEAT_SEEDS));
                currencies.add(new ItemStack(Items.WHEAT));
                currencies.add(new ItemStack(Items.BEEF));
                currencies.add(new ItemStack(Items.PORKCHOP));
                items.add(new ItemStack(WitcheryIngredientItems.BAT_WOOL, 5));
            } else if (animal instanceof EntitySpider) {
                currencies.add(new ItemStack(Items.BEEF));
                currencies.add(new ItemStack(Items.PORKCHOP));
                currencies.add(new ItemStack(Items.CHICKEN));
                currencies.add(new ItemStack(Items.FISH));
                items.add(new ItemStack(Items.STRING, 8));
                items.add(new ItemStack(WitcheryIngredientItems.WEB, 4));
            } else if (animal instanceof EntityCreeper) {
                currencies.add(new ItemStack(Items.GUNPOWDER));
                currencies.add(new ItemStack(Items.FISH));
                if (r.nextDouble() < 0.05) {
                    items.add(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, 2));
                }
                if (animal.world.rand.nextDouble() < 0.1) {
                    items.add(new ItemStack(WitcheryIngredientItems.TREEFYD_SEEDS));
                }
                if (r.nextDouble() < 0.02) {
                    items.add(new ItemStack(WitcheryIngredientItems.CREEPER_HEART, 1));
                }
            } else if (animal.isEntityUndead()) {
                currencies.add(new ItemStack(Items.BONE));
                items.add(new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST, 1));
            } else {
                currencies.add(new ItemStack(Items.BEEF));
                currencies.add(new ItemStack(Items.PORKCHOP));
                currencies.add(new ItemStack(Items.CHICKEN));
                currencies.add(new ItemStack(Items.FISH));
                currencies.add(new ItemStack(Items.WHEAT));
                currencies.add(new ItemStack(Items.WHEAT_SEEDS));
                currencies.add(new ItemStack(Items.CARROT));
                currencies.add(new ItemStack(Items.APPLE));
                currencies.add(new ItemStack(Items.POTATO));
            }
            for (ItemStack itemstack : items) {
                if (itemstack.isEmpty()) continue;
                itemstack.getItem();
                ItemStack goods = itemstack.copy();
                goods.setCount(Math.min(r.nextInt(itemstack.getCount()) + (itemstack.getCount() > 4 ? 3 : 1), goods.getMaxStackSize()));
                ItemStack currency = (ItemStack)currencies.get(r.nextInt(currencies.size()));
                ItemStack cost = currency.copy();
                int multiplier = 1;
                if (goods.getItem() == Items.DIAMOND || goods.getItem() == Items.EMERALD || goods.getItem() == Items.SADDLE || goods.getItem() == WitcheryIngredientItems.TREEFYD_SEEDS || animal.isEntityUndead()) {
                    multiplier = 2;
                }
                int factor = goods.getCount() > 4 ? 1 : 2;
                cost.setCount(Math.min(r.nextInt(2) + goods.getCount() * multiplier * (r.nextInt(2) + factor), currency.getMaxStackSize()));
                MerchantRecipe recipe = new MerchantRecipe(cost, goods);
                recipe.increaseMaxTradeUses(-(6 - r.nextInt(2)));
                list2.add((Object)recipe);
            }
            Collections.shuffle(list2);
            int MAX_ITEMS = r.nextInt(2) + 1;
            for (int i = 0; i < MAX_ITEMS && i < list2.size(); ++i) {
                finalList.add(list2.get(i));
            }
        }

        public void playIntro() {
            this.playGreeting(this.animal);
        }

        public EntityPlayer getCustomer() {
            return this.customer;
        }

        public void setCustomer(EntityPlayer player) {
            this.customer = player;
        }

        public MerchantRecipeList getRecipes(EntityPlayer player) {
            NBTTagCompound nbtTag = this.animal.getEntityData();
            if (this.currentList != null) {
                return this.currentList;
            }
            if (nbtTag.hasKey(STOCKS_KEY)) {
                NBTTagCompound nbtTagStocks = nbtTag.getCompoundTag(STOCKS_KEY);
                this.currentList = nbtTagStocks.isEmpty() ? new MerchantRecipeList() : new MerchantRecipeList(nbtTagStocks);
                return this.currentList;
            }
            this.currentList = new MerchantRecipeList();
            AnimalMerchant.populateList(this.animal, this.currentList);
            nbtTag.setTag(STOCKS_KEY, (NBTBase)this.currentList.getRecipiesAsTags());
            return this.currentList;
        }

        public void useRecipe(MerchantRecipe recipe) {
            if (this.animal != null && this.animal.isEntityAlive() && !this.animal.world.isRemote) {
                recipe.incrementToolUses();
                if (this.currentList != null) {
                    NBTTagCompound nbtTag = this.animal.getEntityData();
                    nbtTag.setTag(STOCKS_KEY, (NBTBase)this.currentList.getRecipiesAsTags());
                }
            }
            this.animal.playLivingSound();
        }

        public void verifySellingItem(ItemStack itemstack) {
            this.animal.playLivingSound();
        }

        public ITextComponent getDisplayName() {
            return this.animal.getDisplayName();
        }

        public World getWorld() {
            return this.animal.world;
        }

        public BlockPos getPos() {
            return this.animal.getPosition();
        }

        @SideOnly(value=Side.CLIENT)
        public void setRecipes(MerchantRecipeList list2) {
        }

        private void playGreeting(EntityLiving animal) {
            animal.playLivingSound();
            animal.playLivingSound();
            animal.playLivingSound();
        }
    }
}

