/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.BloodStorage;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.Taglockable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/item/ItemPlayerCompass;", "Lnet/minecraft/item/Item;", "Lnet/msrandom/witchery/item/Taglockable;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "list", "", "", "advTooltips", "Lnet/minecraft/client/util/ITooltipFlag;", "WitcheryResurrected"})
public final class ItemPlayerCompass
extends Item
implements Taglockable {
    @SideOnly(value=Side.CLIENT)
    public void addInformation(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> list2, @NotNull ITooltipFlag advTooltips) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)advTooltips, (String)"advTooltips");
        super.addInformation(stack, worldIn, list2, advTooltips);
        ITextComponent name2 = BloodStorage.getBloodName$default(this, stack, 0, 2, null);
        if (name2 == null) {
            String string = I18n.format((String)"item.witchery.taglock_kit.unbound", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"item.\" + Wi\u2026+ \".taglock_kit.unbound\")");
            list2.add(string);
        } else {
            list2.add(TextFormatting.DARK_PURPLE.toString() + name2.getFormattedText());
        }
    }

    public ItemPlayerCompass() {
        this.setMaxStackSize(1);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.addPropertyOverride(new ResourceLocation("witchery", "angle"), new IItemPropertyGetter(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public final double getRotation() {
                return this.rotation;
            }

            public final void setRotation(double d) {
                this.rotation = d;
            }

            public final double getRota() {
                return this.rota;
            }

            public final void setRota(double d) {
                this.rota = d;
            }

            public final long getLastUpdateTick() {
                return this.lastUpdateTick;
            }

            public final void setLastUpdateTick(long l) {
                this.lastUpdateTick = l;
            }

            public float apply(@NotNull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float f;
                World currentWorld;
                World world2;
                Entity currentEntity;
                Entity entity2;
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                if (entity == null && !stack.isOnItemFrame()) {
                    return -1.0f;
                }
                EntityLivingBase entityLivingBase = entity;
                if (entityLivingBase != null) {
                    entity2 = (Entity)entityLivingBase;
                } else {
                    EntityItemFrame entityItemFrame = stack.getItemFrame();
                    if (entityItemFrame == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityItemFrame, (String)"stack.itemFrame!!");
                    entity2 = currentEntity = (Entity)entityItemFrame;
                }
                if ((world2 = world) == null) {
                    world2 = currentWorld = currentEntity.world;
                }
                if (ItemTaglockKit.isTaglockPresent(stack, 0)) {
                    double angle = 0.0;
                    EntityLivingBase target = ItemTaglockKit.getBoundEntity(currentWorld, stack, 0);
                    if (target != null && (target.dimension == currentEntity.dimension || target.world.provider.canRespawnHere() && WitcheryDimensions.SPIRIT_WORLD.isInDimension(currentEntity))) {
                        double d1 = currentEntity.rotationYaw;
                        d1 = MathHelper.positiveModulo((double)(d1 / 360.0), (double)1.0);
                        double d = target.posZ - currentEntity.posZ;
                        double d2 = target.posX - currentEntity.posX;
                        boolean bl = false;
                        double d22 = Math.atan2(d, d2) / (Math.PI * 2);
                        angle = 0.5 - (d1 - 0.25 - d22);
                    } else {
                        angle = Math.random();
                    }
                    World world3 = currentWorld;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"currentWorld");
                    angle = this.wobble(world3, angle);
                    f = MathHelper.positiveModulo((float)((float)angle), (float)1.0f);
                } else {
                    f = -1.0f;
                }
                return f;
            }

            private final double wobble(World world, double wobble) {
                if (world.getTotalWorldTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.getTotalWorldTime();
                    double d0 = wobble - this.rotation;
                    d0 = MathHelper.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.positiveModulo((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }
        });
    }
}

