/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityParasyticLouse;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemParasyticLouse
extends Item {
    public ItemParasyticLouse() {
        this.setMaxStackSize(1);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World par3World, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        ItemStack par1ItemStack = player.getHeldItem(hand);
        if (par3World.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        Block i1 = par3World.getBlockState(pos).getBlock();
        BlockPos offset = pos.offset(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && i1 instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = this.spawnCreature(player.getHeldItem(hand), par3World, offset, d0)) instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
            entity.setCustomNameTag(par1ItemStack.getDisplayName());
        }
        if (!player.capabilities.isCreativeMode) {
            par1ItemStack.shrink(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        WitcheryUtils.addGoldenTooltips(PotionUtils.getPotionFromItem((ItemStack)stack).getEffects(), list2);
    }

    public ActionResult<ItemStack> onItemRightClick(World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        ItemStack par1ItemStack = par3EntityPlayer.getHeldItem(hand);
        if (par2World.isRemote) {
            return new ActionResult(EnumActionResult.PASS, (Object)par1ItemStack);
        }
        RayTraceResult movingobjectposition = this.rayTrace(par2World, par3EntityPlayer, true);
        if (movingobjectposition != null && movingobjectposition.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos pos = movingobjectposition.getBlockPos();
            if (!par2World.canMineBlockBody(par3EntityPlayer, pos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)par1ItemStack);
            }
            if (!par3EntityPlayer.canPlayerEdit(pos, movingobjectposition.sideHit, par1ItemStack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)par1ItemStack);
            }
            if (par2World.getBlockState(pos).getMaterial() == Material.WATER) {
                Entity entity = this.spawnCreature(par1ItemStack, par2World, pos, 0.0);
                if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
                    entity.setCustomNameTag(par1ItemStack.getDisplayName());
                }
                if (!par3EntityPlayer.capabilities.isCreativeMode) {
                    par1ItemStack.shrink(1);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    private Entity spawnCreature(ItemStack stack, World par0World, BlockPos pos, double extra) {
        EntityParasyticLouse entity = new EntityParasyticLouse(par0World);
        PotionType damage = PotionUtils.getPotionFromItem((ItemStack)stack);
        if (damage != PotionTypes.EMPTY) {
            entity.setBitePotionEffect(damage);
        }
        entity.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + extra, (double)pos.getZ() + 0.5, MathHelper.wrapDegrees((float)(par0World.rand.nextFloat() * 360.0f)), 0.0f);
        entity.enablePersistence();
        entity.rotationYawHead = entity.rotationYaw;
        entity.renderYawOffset = entity.rotationYaw;
        entity.onInitialSpawn(entity.world.getDifficultyForLocation(pos), null);
        par0World.spawnEntity((Entity)entity);
        entity.playLivingSound();
        return entity;
    }
}

