/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.EntityUtil;

public class ItemNecromanticStone
extends Item {
    public ItemNecromanticStone() {
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (!world.isRemote) {
            ItemStack stack = player.getHeldItem(hand);
            double range = 15.0;
            RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, player, true, range);
            if (mop != null) {
                switch (mop.typeOfHit) {
                    case ENTITY: {
                        if (!(mop.entityHit instanceof EntityLivingBase)) break;
                        if (!player.isSneaking()) {
                            EntityLivingBase targetEntityLivingBase = (EntityLivingBase)mop.entityHit;
                            int r = 50;
                            int minionCount = 0;
                            AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)r, player.posY - range, player.posZ - (double)r, player.posX + (double)r, player.posY + range, player.posZ + (double)r);
                            for (EntityLiving nearbyLivingEntity : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                                if (nearbyLivingEntity.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD || !PotionEnslaved.isMobEnslavedBy(nearbyLivingEntity, player)) continue;
                                ++minionCount;
                                EntityUtil.setTarget(nearbyLivingEntity, targetEntityLivingBase);
                            }
                            if (minionCount <= 0) break;
                            targetEntityLivingBase.playSound(SoundEvents.ENTITY_ZOMBIE_DEATH, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)targetEntityLivingBase, 0.5f, 2.0f, EnumParticleTypes.CRIT), (Entity)targetEntityLivingBase);
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        if (WitcheryInfusedBrews.GRAVE.isActive(player) && WitcheryInfusedBrews.GRAVE.tryUseEffect(player, mop)) {
                            mop.entityHit.playSound(SoundEvents.ENTITY_ZOMBIE_INFECT, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(mop.entityHit, 1.0f, 1.0f, EnumParticleTypes.SPELL_MOB), mop.entityHit);
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        mop.entityHit.playSound(SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(mop.entityHit, 1.0f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), mop.entityHit);
                        break;
                    }
                    case BLOCK: {
                        if (mop.sideHit != EnumFacing.UP) break;
                        int minionCount = 0;
                        int r = 50;
                        AxisAlignedBB bounds2 = new AxisAlignedBB(player.posX - (double)r, player.posY - range, player.posZ - (double)r, player.posX + (double)r, player.posY + range, player.posZ + (double)r);
                        for (EntityLiving creature : world.getEntitiesWithinAABB(EntityLiving.class, bounds2)) {
                            EntityCreature creature2;
                            EntityCreature entityCreature = creature2 = creature instanceof EntityCreature ? (EntityCreature)creature : null;
                            if (creature.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD || !PotionEnslaved.isMobEnslavedBy(creature, player)) continue;
                            ++minionCount;
                            creature.setAttackTarget(null);
                            creature.setRevengeTarget(null);
                            if (!(creature instanceof EntitySpider) && creature.getNavigator().tryMoveToXYZ((double)mop.getBlockPos().getX(), (double)(mop.getBlockPos().getY() + 1), (double)mop.getBlockPos().getZ(), 1.0) || creature2 == null) continue;
                            creature2.getNavigator().tryMoveToXYZ((double)mop.getBlockPos().getX() + 0.5, (double)mop.getBlockPos().getY(), (double)mop.getBlockPos().getZ() + 0.5, 0.3);
                        }
                        if (minionCount <= 0) break;
                        world.playSound(null, 0.5 + (double)mop.getBlockPos().getX(), (double)(mop.getBlockPos().getY() + 1), 0.5 + (double)mop.getBlockPos().getZ(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)mop.getBlockPos().getX(), (double)(mop.getBlockPos().getY() + 1), 0.5 + (double)mop.getBlockPos().getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, mop.getBlockPos().up());
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
            }
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        }
        return super.onItemRightClick(world, player, hand);
    }

    public EnumRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public boolean hasEffect(ItemStack stack) {
        return true;
    }
}

