/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockPlacedItem;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.StrokeSet;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.resources.SymbolEffectManager;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemMysticBranch
extends Item {
    private static final int MAX_STROKES = 15;

    public ItemMysticBranch() {
        this.setMaxStackSize(1);
        this.setFull3D();
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.addPropertyOverride(new ResourceLocation("witchery", "using"), (stack, world, entity) -> entity != null && entity.isHandActive() && entity.getActiveItemStack() == stack ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return super.onDroppedByPlayer(item, player);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 36000;
    }

    public boolean hasEffect(ItemStack par1ItemStack) {
        return true;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.getHeldItem(handIn);
        NBTTagCompound nbtTag = player.getEntityData();
        if (!player.world.isRemote) {
            nbtTag.removeTag("WitcherySpellEffect");
            nbtTag.removeTag("WitcherySpellEffectEnhanced");
        }
        nbtTag.setByteArray("Strokes", new byte[0]);
        nbtTag.setFloat("StartPitch", player.rotationPitch);
        nbtTag.setFloat("StartYaw", player.rotationYawHead);
        player.setActiveHand(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.getBlockState(pos).getBlock() == WitcheryBlocks.ALTAR && facing == EnumFacing.UP && world.isAirBlock(pos.up())) {
            BlockPlacedItem.placeInWorld(hand, player, world, pos.up());
            return world.isRemote ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        return super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int countdown) {
        NBTTagCompound nbtTag = entity.getEntityData();
        float yawDiff = nbtTag.getFloat("StartYaw") - entity.rotationYawHead;
        float pitchDiff = nbtTag.getFloat("StartPitch") - entity.rotationPitch;
        StrokeArray strokes = new StrokeArray(nbtTag.getByteArray("Strokes"));
        int strokesStart = strokes.getRaw().size();
        if (!SymbolEffectManager.INSTANCE.validStrokes(strokes) && strokesStart <= 15) {
            StrokeSet effect;
            if (pitchDiff >= 6.0f && yawDiff <= -6.0f) {
                strokes.add(BranchStroke.DOWN_LEFT);
            } else if (pitchDiff >= 6.0f && yawDiff >= 6.0f) {
                strokes.add(BranchStroke.UP_LEFT);
            } else if (pitchDiff <= -6.0f && yawDiff <= -6.0f) {
                strokes.add(BranchStroke.DOWN_RIGHT);
            } else if (pitchDiff <= -6.0f && yawDiff >= 6.0f) {
                strokes.add(BranchStroke.UP_RIGHT);
            } else if (pitchDiff >= 7.0f) {
                strokes.add(BranchStroke.UP);
            } else if (pitchDiff <= -7.0f) {
                strokes.add(BranchStroke.DOWN);
            } else if (yawDiff <= -7.0f) {
                strokes.add(BranchStroke.RIGHT);
            } else if (yawDiff >= 7.0f) {
                strokes.add(BranchStroke.LEFT);
            }
            nbtTag.setByteArray("Strokes", strokes.getBytes().toByteArray());
            if (strokes.getRaw().size() > strokesStart) {
                nbtTag.setFloat("StartPitch", entity.rotationPitch);
                nbtTag.setFloat("StartYaw", entity.rotationYawHead);
            }
            if ((effect = SymbolEffectManager.INSTANCE.getEffect(strokes)) != null) {
                nbtTag.setString("WitcherySpellEffect", ((ResourceLocation)SymbolEffect.REGISTRY.getKey(effect.getResult())).toString());
                nbtTag.setInteger("WitcherySpellEffectEnhanced", effect.getLevel());
            }
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase entity, int countdown) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            NBTTagCompound nbtTag = player.getEntityData();
            if (!world.isRemote) {
                ResourceLocation effectID = new ResourceLocation(nbtTag.getString("WitcherySpellEffect"));
                int level = 1;
                if (nbtTag.hasKey("WitcherySpellEffectEnhanced")) {
                    level = nbtTag.getInteger("WitcherySpellEffectEnhanced");
                    nbtTag.removeTag("WitcherySpellEffectEnhanced");
                }
                nbtTag.removeTag("WitcherySpellEffect");
                SymbolEffect effect = (SymbolEffect)SymbolEffect.REGISTRY.get(effectID);
                NBTTagCompound nbtPerm = player.getEntityData();
                if (effect != null) {
                    if (player.capabilities.isCreativeMode || playerEx.infusionPower.getCurrentPower() > 0) {
                        if (effect.hasValidInfusion(player, playerEx.infusionPower.getInfusionType())) {
                            if (effect.hasValidKnowledge(player, nbtPerm)) {
                                long ticksRemaining = effect.cooldownRemaining(nbtPerm);
                                if (ticksRemaining <= 0L || player.capabilities.isCreativeMode) {
                                    if (level > 1) {
                                        PotionEffect potion;
                                        int newLevel = 1;
                                        if (player.isPotionActive(WitcheryPotionEffects.WORSHIP) && level <= (potion = player.getActivePotionEffect(WitcheryPotionEffects.WORSHIP)).getAmplifier() + 2) {
                                            newLevel = level;
                                        }
                                        level = newLevel;
                                    }
                                    if (player.capabilities.isCreativeMode || playerEx.infusionPower.getCurrentPower() >= effect.getChargeCost(player, level)) {
                                        effect.perform(world, player, level);
                                        if (!player.capabilities.isCreativeMode) {
                                            Infusion.setCurrentEnergy(player, playerEx.infusionPower.getCurrentPower() - effect.getChargeCost(player, level));
                                        }
                                    } else {
                                        player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".insufficient_infusion_power", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                                        world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    }
                                } else {
                                    player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".effect_not_ready", new Object[]{ticksRemaining / 20L}).setStyle(new Style().setColor(TextFormatting.RED)), true);
                                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                }
                            } else {
                                player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".unknown_effect", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            }
                        } else {
                            player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".weak_infusion", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        }
                    } else {
                        player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".no_infusion", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                        world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    }
                } else {
                    player.sendStatusMessage(new TextComponentTranslation(this.getTranslationKey() + ".unknown_symbol", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                nbtTag.removeTag("Strokes");
                nbtTag.removeTag("StartYaw");
                nbtTag.removeTag("StartPitch");
            }
        }
    }
}

