/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockWitchCrop;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.MutableBlock;

public class ItemMutandis
extends Item {
    private final boolean extremis;

    public ItemMutandis(boolean extremis) {
        this.extremis = extremis;
    }

    public static void setBlockToClay(World world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        Block blockAbove = world.getBlockState(pos.up()).getBlock();
        if (block == Blocks.DIRT && (blockAbove == Blocks.WATER || blockAbove == Blocks.FLOWING_WATER)) {
            world.setBlockState(pos, Blocks.CLAY.getDefaultState());
            if (!world.isRemote) {
                world.playSound(null, 0.5 + (double)pos.getX(), 1.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), SoundEvents.ENTITY_SLIME_JUMP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), 1.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, 0.5 + (double)pos.getX(), 1.5 + (double)pos.getY(), 0.5 + (double)pos.getZ());
            }
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            ItemStack stack = player.getHeldItem(hand);
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            Block blockAbove = world.getBlockState(pos.up()).getBlock();
            if (this.extremis && (block == Blocks.GRASS || block == Blocks.MYCELIUM)) {
                if (world.rand.nextBoolean()) {
                    world.setBlockState(pos, (block == Blocks.GRASS ? Blocks.MYCELIUM : Blocks.GRASS).getDefaultState());
                }
                world.playSound(null, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, pos.up());
                stack.shrink(1);
            } else if (this.extremis && block == Blocks.DIRT && (blockAbove == Blocks.WATER || blockAbove == Blocks.FLOWING_WATER)) {
                if (world.rand.nextBoolean()) {
                    ItemMutandis.setBlockToClay(world, pos);
                    ItemMutandis.setBlockToClay(world, pos.east());
                    ItemMutandis.setBlockToClay(world, pos.west());
                    ItemMutandis.setBlockToClay(world, pos.south());
                    ItemMutandis.setBlockToClay(world, pos.north());
                } else {
                    world.playSound(null, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, pos.up());
                }
                stack.shrink(1);
            } else {
                MutableBlock[] blocks;
                HashSet<MutableBlock> list2 = new HashSet<MutableBlock>();
                if (block == Blocks.FLOWER_POT && state.getValue((IProperty)BlockFlowerPot.CONTENTS) != BlockFlowerPot.EnumFlowerType.EMPTY) {
                    blocks = new ArrayList();
                    for (int i = 1; i < 15; ++i) {
                        blocks.add(new MutableBlock(Blocks.FLOWER_POT.getDefaultState().withProperty((IProperty)BlockFlowerPot.LEGACY_DATA, (Comparable)Integer.valueOf(i))));
                    }
                    list2.addAll((Collection<MutableBlock>)blocks);
                } else {
                    blocks = new MutableBlock[]{new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.OAK)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.SPRUCE)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.BIRCH)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.JUNGLE)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.ACACIA)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.DARK_OAK)), new MutableBlock(WitcheryWoodTypes.ROWAN.getSapling().getDefaultState()), new MutableBlock(WitcheryWoodTypes.ALDER.getSapling().getDefaultState()), new MutableBlock(WitcheryWoodTypes.HAWTHORN.getSapling().getDefaultState()), new MutableBlock(WitcheryBlocks.EMBER_MOSS.getDefaultState()), new MutableBlock(Blocks.TALLGRASS.getDefaultState().withProperty((IProperty)BlockTallGrass.TYPE, (Comparable)BlockTallGrass.EnumType.GRASS)), new MutableBlock(Blocks.WATERLILY.getDefaultState()), new MutableBlock(Blocks.BROWN_MUSHROOM.getDefaultState()), new MutableBlock(Blocks.RED_MUSHROOM.getDefaultState()), new MutableBlock(Blocks.RED_FLOWER.getDefaultState()), new MutableBlock(Blocks.YELLOW_FLOWER.getDefaultState()), new MutableBlock(WitcheryBlocks.SPANISH_MOSS.getDefaultState().withProperty((IProperty)BlockVine.SOUTH, (Comparable)Boolean.valueOf(true)))};
                    Collections.addAll(list2, blocks);
                    for (IBlockState extra : WitcheryConfigOptions.mutandisExtras) {
                        list2.add(new MutableBlock(extra));
                    }
                    if (this.extremis) {
                        IProperty age = state.getBlock().getBlockState().getProperty("age");
                        int currentAge = age == null ? 0 : (Integer)state.getValue(age);
                        MutableBlock[] extremisBlocks = new MutableBlock[]{new MutableBlock(null, Blocks.CARROTS.getDefaultState().withProperty((IProperty)BlockCrops.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.POTATOES.getDefaultState().withProperty((IProperty)BlockCrops.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.WHEAT.getDefaultState().withProperty((IProperty)BlockCrops.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, WitcheryBlocks.BELLADONNA_SEEDS.getDefaultState().withProperty((IProperty)BlockWitchCrop.AGE4, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, WitcheryBlocks.MANDRAKE_SEEDS.getDefaultState().withProperty((IProperty)BlockWitchCrop.AGE4, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, WitcheryBlocks.ARTICHOKE_SEEDS.getDefaultState().withProperty((IProperty)BlockWitchCrop.AGE4, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.REEDS.getDefaultState().withProperty((IProperty)BlockReed.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.PUMPKIN_STEM.getDefaultState().withProperty((IProperty)BlockStem.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.MELON_STEM.getDefaultState().withProperty((IProperty)BlockStem.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 7)))), new MutableBlock(null, Blocks.NETHER_WART.getDefaultState().withProperty((IProperty)BlockNetherWart.AGE, (Comparable)Integer.valueOf(Math.min(currentAge, 3)))), new MutableBlock(null, Blocks.CACTUS.getDefaultState())};
                        Collections.addAll(list2, extremisBlocks);
                    } else if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player)) {
                        list2.add(new MutableBlock(null, Blocks.NETHER_WART.getDefaultState().withProperty((IProperty)BlockNetherWart.AGE, (Comparable)Integer.valueOf(3))));
                    }
                }
                MutableBlock mutableBlock = new MutableBlock(state);
                if (list2.contains((Object)mutableBlock)) {
                    list2.remove((Object)mutableBlock);
                    ((MutableBlock)((Object)CollectionsKt.elementAt(list2, (int)world.rand.nextInt(list2.size())))).mutate(world, pos);
                    world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
                    stack.shrink(1);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

