/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class ItemMoonCharm
extends Item {
    public ItemMoonCharm() {
        this.setMaxStackSize(1);
        this.setMaxDamage(49);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean isWolfsbaneInactive(EntityPlayer player, PlayerExtendedData playerEx) {
        PotionEffect potion = player.getActivePotionEffect(WitcheryPotionEffects.WOLFSBANE);
        if (potion == null) {
            return true;
        }
        int amplifier = 1 + Math.max(0, potion.getAmplifier() * 3 - 1);
        return amplifier < playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.addInformation(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[0]));
    }

    public boolean getIsRepairable(ItemStack item, ItemStack otherMaterial) {
        return otherMaterial.isItemEqual(new ItemStack(Items.GOLD_INGOT));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 60;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int countdown) {
        EntityPlayer player;
        PlayerExtendedData playerEx;
        WerewolfTransformation transformation;
        if (!entity.world.isRemote && entity instanceof EntityPlayer && countdown == Math.max(((transformation = (playerEx = WitcheryUtils.getExtension(player = (EntityPlayer)entity)).getTransformation(WitcheryTransformations.WEREWOLF)).getLevel() - 1) * 4, 1)) {
            if (ItemMoonCharm.isWolfsbaneInactive(player, playerEx) && ShapeShift.INSTANCE.canControlTransform(transformation)) {
                AlternateForm form = player.isSneaking() && ShapeShift.INSTANCE.isWolfmanAllowed(transformation) ? WitcheryAlternateForms.WOLFMAN : WitcheryAlternateForms.WOLF;
                AlternateForm currentForm = playerEx.getCurrentForm();
                if (currentForm == null || AlternateFormStatManager.INSTANCE.getStats(currentForm).canHowl()) {
                    playerEx.setCurrentForm(currentForm == form ? null : form);
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryUtils.addNewParticles(player.world, EnumParticleTypes.EXPLOSION_NORMAL, player.posX, player.posY, player.posZ, 0.0, 30, 1.5, 1.5);
                } else {
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryUtils.addNewParticles(player.world, EnumParticleTypes.SMOKE_NORMAL, player.posX, player.posY, player.posZ, 0.0, 20, 0.5, 0.5);
                }
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_PLING, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(player.world, EnumParticleTypes.SMOKE_NORMAL, player.posX, player.posY, player.posZ, 0.0, 20, 0.5, 0.5);
            }
            stack.damageItem(1, (EntityLivingBase)player);
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }
}

