/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/item/ItemLeapingLily;", "Lnet/minecraft/item/ItemBlock;", "block", "Lnet/minecraft/block/Block;", "(Lnet/minecraft/block/Block;)V", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "WitcheryResurrected"})
public final class ItemLeapingLily
extends ItemBlock {
    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand hand) {
        ActionResult actionResult;
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = playerIn.getHeldItem(hand);
        RayTraceResult hit = this.rayTrace(worldIn, playerIn, true);
        if (hit == null) {
            ActionResult actionResult2 = ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            actionResult = actionResult2;
            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult2, (String)"ActionResult.newResult(E\u2026ActionResult.PASS, stack)");
        } else {
            if (hit.typeOfHit == RayTraceResult.Type.BLOCK) {
                IBlockState state;
                BlockPos blockpos = hit.getBlockPos();
                if (!worldIn.isBlockModifiable(playerIn, blockpos) || !playerIn.canPlayerEdit(blockpos.offset(hit.sideHit), hit.sideHit, stack)) {
                    ActionResult actionResult3 = ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                    Intrinsics.checkExpressionValueIsNotNull((Object)actionResult3, (String)"ActionResult.newResult(E\u2026ActionResult.FAIL, stack)");
                    return actionResult3;
                }
                BlockPos blockpos1 = blockpos.up();
                IBlockState iBlockState = state = worldIn.getBlockState(blockpos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                if (iBlockState.getMaterial() == Material.WATER) {
                    Integer n = (Integer)state.getValue((IProperty)BlockLiquid.LEVEL);
                    if (n != null && n == 0 && worldIn.isAirBlock(blockpos1)) {
                        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)worldIn, (BlockPos)blockpos1);
                        Block block = this.block;
                        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"block");
                        worldIn.setBlockState(blockpos1, block.getDefaultState());
                        BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)playerIn, (BlockSnapshot)snapshot, (EnumFacing)EnumFacing.UP, (EnumHand)hand);
                        Intrinsics.checkExpressionValueIsNotNull((Object)placeEvent, (String)"ForgeEventFactory.onPlay\u2026hot, EnumFacing.UP, hand)");
                        if (placeEvent.isCanceled()) {
                            snapshot.restore(true, false);
                            ActionResult actionResult4 = ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult4, (String)"ActionResult.newResult(E\u2026ActionResult.FAIL, stack)");
                            return actionResult4;
                        }
                        Block block2 = this.block;
                        Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
                        worldIn.setBlockState(blockpos1, block2.getDefaultState(), 11);
                        if (playerIn instanceof EntityPlayerMP) {
                            CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)playerIn, blockpos1, stack);
                        }
                        if (!playerIn.capabilities.isCreativeMode) {
                            stack.shrink(1);
                        }
                        playerIn.addStat(StatList.getObjectUseStats((Item)((Item)this)));
                        worldIn.playSound(playerIn, blockpos, SoundEvents.BLOCK_WATERLILY_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ActionResult actionResult5 = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult5, (String)"ActionResult.newResult(E\u2026ionResult.SUCCESS, stack)");
                        return actionResult5;
                    }
                }
            }
            ActionResult actionResult6 = ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            actionResult = actionResult6;
            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult6, (String)"ActionResult.newResult(E\u2026ActionResult.FAIL, stack)");
        }
        return actionResult;
    }

    public ItemLeapingLily(@Nullable Block block) {
        super(block);
    }
}

