/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.Nullable;

public class ItemHuntsHorn
extends Item {
    public ItemHuntsHorn() {
        this.setMaxDamage(1);
        this.setMaxStackSize(1);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.addInformation(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[0]));
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 40;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int countdown) {
        if (player instanceof EntityPlayer && !player.world.isRemote && countdown == 1) {
            player.world.playSound(null, player.getPosition(), WitcherySounds.ITEM_HORN_USE, player.getSoundCategory(), 1.0f, 1.0f);
            EntityCreature creature = Infusion.spawnCreature(player.world, EntityHornedHuntsman.class, player.getPosition(), player, 2, 8, EnumParticleTypes.EXPLOSION_NORMAL, SoundEvents.ENTITY_WITHER_SPAWN);
            if (creature != null) {
                EntityHornedHuntsman huntsman = (EntityHornedHuntsman)creature;
                huntsman.causeExplosiveEntrance();
                huntsman.enablePersistence();
                huntsman.ignite();
                stack.damageItem(2, player);
            }
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }
}

