/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelHunterClothes;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.traits.Invisible;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemHunterClothes
extends ItemArmor
implements ISpecialArmor,
Invisible {
    private final boolean silvered;
    private final boolean garlicked;
    @SideOnly(value=Side.CLIENT)
    private ModelHunterClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelHunterClothes modelClothesLegs;

    public ItemHunterClothes(EntityEquipmentSlot armorSlot) {
        this(armorSlot, false);
    }

    public ItemHunterClothes(EntityEquipmentSlot armorSlot, boolean silvered) {
        this(armorSlot, silvered, false);
    }

    public ItemHunterClothes(EntityEquipmentSlot armorSlot, boolean silvered, boolean garlicked) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.silvered = silvered;
        this.garlicked = garlicked;
        this.setMaxDamage(ItemArmor.ArmorMaterial.IRON.getDurability(armorSlot));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean isFullSetWorn(EntityLivingBase entity, boolean silvered) {
        for (int i = 2; i <= 5; ++i) {
            ItemStack item = entity.getItemStackFromSlot(EntityEquipmentSlot.values()[i]);
            if (!(item.getItem() instanceof ItemHunterClothes)) {
                return false;
            }
            ItemHunterClothes clothes = (ItemHunterClothes)item.getItem();
            if (!silvered || clothes.silvered) continue;
            return false;
        }
        return true;
    }

    public static boolean isMagicalProtectionActive(EntityLivingBase entity) {
        return entity == null || !ItemHunterClothes.isFullSetWorn(entity, false) || entity.world == null || !(entity.world.rand.nextDouble() < 0.25);
    }

    public static boolean isCurseProtectionActive(EntityLivingBase entity) {
        return entity != null && ItemHunterClothes.isFullSetWorn(entity, false) && entity.world != null && entity.world.rand.nextDouble() < 0.9;
    }

    public static boolean isWolfProtectionActive(EntityLivingBase entity) {
        return entity != null && ItemHunterClothes.isFullSetWorn(entity, true);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (!stack.isEmpty() && this.armorType == EntityEquipmentSlot.LEGS) {
            return "witchery:textures/entities/hunterclothes2" + (type == null ? "" : "_overlay") + ".png";
        }
        if (!stack.isEmpty()) {
            return "witchery:textures/entities/hunterclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    public boolean hasColor(ItemStack stack) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.isRemote && player.ticksExisted % 20 == 2) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            if (this.silvered && playerEx.isTransformation(WitcheryTransformations.WEREWOLF) || this.garlicked && playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                player.attackEntityFrom(DamageSource.IN_FIRE, 1.0f);
            }
        }
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return super.getColor(stack);
        }
        int color2 = super.getColor(stack);
        if (color2 == 10511680) {
            color2 = stack.getItem() == WitcheryEquipmentItems.HUNTER_BOOTS ? 1642763 : (stack.getItem() == WitcheryEquipmentItems.HUNTER_LEGS ? 4798251 : 4139550);
        }
        return color2;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelHunterClothes(0.4f);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelHunterClothes(0.01f);
        }
        return armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.FEET ? this.modelClothesChest : this.modelClothesLegs;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.silvered && source != null && CreatureUtil.isWerewolf(source.getTrueSource())) {
            source.getTrueSource().attackEntityFrom(DamageSource.IN_FIRE, 1.0f);
            return new ISpecialArmor.ArmorProperties(0, (double)this.damageReduceAmount * 2.5 / 25.0, armor.getMaxDamage() + 1 - armor.getItemDamage());
        }
        if (this.garlicked && source != null && CreatureUtil.isVampire(source.getTrueSource())) {
            return new ISpecialArmor.ArmorProperties(0, (double)this.damageReduceAmount * 2.5 / 25.0, armor.getMaxDamage() + 1 - armor.getItemDamage());
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.damageReduceAmount / 25.0, armor.getMaxDamage() + 1 - armor.getItemDamage());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.damageReduceAmount;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.silvered && source != null && CreatureUtil.isWerewolf(source.getTrueSource())) {
            return;
        }
        if (this.garlicked && source != null && CreatureUtil.isVampire(source.getTrueSource())) {
            return;
        }
        stack.damageItem(damage, entity);
    }
}

