/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelGoblinClothes;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemGoblinClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesChest;
    @SideOnly(value=Side.CLIENT)
    private ModelGoblinClothes modelClothesLegs;

    public ItemGoblinClothes(EntityEquipmentSlot armorSlot) {
        super(armorSlot == EntityEquipmentSlot.HEAD ? ItemArmor.ArmorMaterial.IRON : ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.setMaxDamage(armorSlot == EntityEquipmentSlot.HEAD ? ItemArmor.ArmorMaterial.DIAMOND.getDurability(armorSlot) : ItemArmor.ArmorMaterial.IRON.getDurability(armorSlot));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean isQuiverWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.inventory.armorInventory.get(2);
        return !currentArmor.isEmpty() && currentArmor.getItem() == WitcheryEquipmentItems.MOGS_QUIVER;
    }

    private static boolean isHelmWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.inventory.armorInventory.get(3);
        return !currentArmor.isEmpty() && currentArmor.getItem() == WitcheryEquipmentItems.KOBOLDITE_HELM;
    }

    public static boolean isBeltWorn(EntityPlayer player) {
        ItemStack currentArmor = (ItemStack)player.inventory.armorInventory.get(1);
        return !currentArmor.isEmpty() && currentArmor.getItem() == WitcheryEquipmentItems.GULGS_GURDLE;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.isRemote && world.getTotalWorldTime() % 100L == 0L) {
            double R = 8.0;
            AxisAlignedBB bb = new AxisAlignedBB(player.posX - R, player.posY - R, player.posZ - R, player.posX + R, player.posY + R, player.posZ + R);
            List players = world.getEntitiesWithinAABB(EntityPlayer.class, bb);
            for (EntityPlayer otherPlayer : players) {
                if (player == otherPlayer || (!ItemGoblinClothes.isQuiverWorn(player) || !ItemGoblinClothes.isBeltWorn(otherPlayer)) && (!ItemGoblinClothes.isQuiverWorn(otherPlayer) || !ItemGoblinClothes.isBeltWorn(player))) continue;
                if (player.isPotionActive(MobEffects.RESISTANCE)) {
                    player.removePotionEffect(MobEffects.RESISTANCE);
                }
                player.addPotionEffect(new PotionEffect(MobEffects.RESISTANCE, 200, 1));
                return;
            }
        }
        if (!world.isRemote && ItemGoblinClothes.isHelmWorn(player) && world.getTotalWorldTime() % 5L == 1L) {
            double R2 = 16.0;
            AxisAlignedBB bb2 = new AxisAlignedBB(player.posX - R2, player.posY - R2, player.posZ - R2, player.posX + R2, player.posY + R2, player.posZ + R2);
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, bb2);
            for (EntityLivingBase otherPlayer2 : entities) {
                if (player == otherPlayer2 || !this.shouldAffectTarget((EntityLivingBase)player, otherPlayer2)) continue;
                if (otherPlayer2 instanceof EntityPlayer) {
                    double yawRadians = Math.atan2(otherPlayer2.posZ - player.posZ, otherPlayer2.posX - player.posZ);
                    double yaw = Math.toDegrees(yawRadians) + 180.0;
                    float rev = ((float)yaw + 90.0f) % 360.0f;
                    if (otherPlayer2 instanceof EntityPlayerMP) {
                        SPacketPlayerPosLook packet2 = new SPacketPlayerPosLook(otherPlayer2.posX, otherPlayer2.posY, otherPlayer2.posZ, rev, otherPlayer2.rotationPitch, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), ((EntityPlayerMP)otherPlayer2).connection.teleportId);
                        ((EntityPlayerMP)otherPlayer2).connection.sendPacket((Packet)packet2);
                    }
                    if (otherPlayer2.isPotionActive(MobEffects.HUNGER)) continue;
                    otherPlayer2.addPotionEffect(new PotionEffect(MobEffects.HUNGER, 100, 0));
                    continue;
                }
                if (otherPlayer2.isPotionActive(MobEffects.WEAKNESS)) continue;
                otherPlayer2.addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 100, 0));
            }
        }
    }

    private boolean shouldAffectTarget(EntityLivingBase player, EntityLivingBase target) {
        ItemStack itemstack = target.getItemStackFromSlot(EntityEquipmentSlot.FEET);
        if (!itemstack.isEmpty() && itemstack.getItem() == Item.getItemFromBlock((Block)Blocks.PUMPKIN)) {
            return false;
        }
        Vec3d vec3 = target.getLook(1.0f).normalize();
        Vec3d vec4 = new Vec3d(player.posX - target.posX, player.getEntityBoundingBox().minY + (double)(player.height / 2.0f) - (target.posY + (double)target.getEyeHeight()), player.posZ - target.posZ);
        double d0 = vec4.length();
        double d2 = vec3.dotProduct(vec4 = vec4.normalize());
        return d2 > 1.0 - 0.025 / d0 && target.canEntityBeSeen((Entity)player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack) {
        return super.hasEffect(stack) || stack.getItem() != WitcheryEquipmentItems.KOBOLDITE_HELM;
    }

    public boolean hasColor(ItemStack stack) {
        return false;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return 0xFFFFFF;
        }
        return super.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return this.armorType != EntityEquipmentSlot.HEAD ? EnumRarity.EPIC : EnumRarity.RARE;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        if (!stack.isEmpty()) {
            String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (stack.isEmpty()) {
            return null;
        }
        if (slot == EntityEquipmentSlot.HEAD) {
            return "witchery:textures/entities/goblinclothes_head" + (type == null ? "" : "_overlay") + ".png";
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return "witchery:textures/entities/goblinclothes_legs" + (type == null ? "" : "_overlay") + ".png";
        }
        return "witchery:textures/entities/goblinclothes" + (type == null ? "" : "_overlay") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.modelClothesChest == null) {
            this.modelClothesChest = new ModelGoblinClothes(0.61f);
        }
        if (this.modelClothesLegs == null) {
            this.modelClothesLegs = new ModelGoblinClothes(0.0f);
        }
        return armorSlot == EntityEquipmentSlot.LEGS ? this.modelClothesLegs : this.modelClothesChest;
    }
}

