/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.passive.EntityElle;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.BloodStorage;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemGlassGoblet
extends Item
implements BloodStorage {
    private final boolean isFull;

    public ItemGlassGoblet(boolean isFull) {
        this.isFull = isFull;
        this.setMaxStackSize(1);
        if (!isFull) {
            this.setCreativeTab(WitcheryGeneralItems.TAB);
        }
    }

    private static boolean tryConvertToVampire(EntityLiving target, int blood, EntityPlayer player, ItemStack stack) {
        PotionEffect effect = target.getActivePotionEffect(WitcheryPotionEffects.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 5) {
            if (blood == 0) {
                if (ItemGlassGoblet.isCoffinNear(player.world, (Entity)target)) {
                    ItemGlassGoblet.convertToVampire(target);
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                    if (transformation.getLevel() == 9 && transformation.getCanLevelUp() && ItemGlassGoblet.getBloodOwner(stack, player.world) == player && transformation.levelUp()) {
                        playerEx.sync();
                    }
                    return true;
                }
                player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".needs_coffin", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            } else {
                player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".victim_has_blood", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
        } else {
            player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".victim_not_transfixed", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
        }
        return false;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
        ITextComponent bloodName;
        super.addInformation(stack, worldIn, list2, advTooltips);
        if (this.isFull && (bloodName = this.getBloodName(stack, 0)) != null) {
            list2.add(I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[]{bloodName.setStyle(new Style().setColor(TextFormatting.DARK_RED)).getFormattedText()}));
        }
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 32;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return this.isFull ? EnumAction.DRINK : EnumAction.BLOCK;
    }

    private static Entity getBloodOwner(ItemStack stack, World world) {
        NBTTagCompound tag;
        if (stack.hasTagCompound() && (tag = WitcheryUtils.getOrCreateTag(stack)).hasUniqueId("ID")) {
            return ((WorldServer)world).getEntityFromUuid(tag.getUniqueId("ID"));
        }
        return null;
    }

    private boolean isElleNear(World world, BlockPos pos) {
        return world.getEntitiesWithinAABB(EntityElle.class, new AxisAlignedBB(0.5 + (double)pos.getX() - 32.0, (double)pos.getY() - 32.0, 0.5 + (double)pos.getZ() - 32.0, 0.5 + (double)pos.getX() + 32.0, (double)pos.getY() + 32.0, 0.5 + (double)pos.getY() + 32.0)).size() > 0;
    }

    private static boolean isRitual(World world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() != Blocks.SKULL) {
            return false;
        }
        TileEntitySkull skull = (TileEntitySkull)world.getTileEntity(pos);
        if (skull == null || skull.getSkullType() != 0) {
            return false;
        }
        Block string = Blocks.TRIPWIRE;
        boolean b = world.getBlockState(pos.north(3)).getBlock() == string;
        b &= world.getBlockState(pos.add(1, 0, -3)).getBlock() == string;
        b &= world.getBlockState(pos.add(2, 0, -3)).getBlock() == string;
        b &= world.getBlockState(pos.add(2, 0, -2)).getBlock() == string;
        b &= world.getBlockState(pos.add(3, 0, -2)).getBlock() == string;
        b &= world.getBlockState(pos.add(3, 0, -1)).getBlock() == string;
        b &= world.getBlockState(pos.east(3)).getBlock() == string;
        b &= world.getBlockState(pos.add(3, 0, 1)).getBlock() == string;
        b &= world.getBlockState(pos.add(3, 0, 2)).getBlock() == string;
        if (!(b &= world.getBlockState(pos.add(2, 0, 2)).getBlock() == string)) {
            return false;
        }
        b = world.getBlockState(pos.add(2, 0, 3)).getBlock() == string;
        b &= world.getBlockState(pos.add(1, 0, 3)).getBlock() == string;
        b &= world.getBlockState(pos.south(3)).getBlock() == string;
        b &= world.getBlockState(pos.add(-1, 0, 3)).getBlock() == string;
        b &= world.getBlockState(pos.add(-2, 0, 3)).getBlock() == string;
        b &= world.getBlockState(pos.add(-2, 0, 2)).getBlock() == string;
        b &= world.getBlockState(pos.add(-3, 0, 2)).getBlock() == string;
        b &= world.getBlockState(pos.add(-3, 0, 1)).getBlock() == string;
        if (!(b &= world.getBlockState(pos.west(3)).getBlock() == string)) {
            return false;
        }
        Block candle = Blocks.TORCH;
        b = world.getBlockState(pos.add(-3, 0, 3)).getBlock() == candle;
        b &= world.getBlockState(pos.add(-3, 0, -3)).getBlock() == candle;
        b &= world.getBlockState(pos.add(3, 0, 3)).getBlock() == candle;
        b &= world.getBlockState(pos.add(3, 0, -3)).getBlock() == candle;
        BlockRedstoneWire redstone = Blocks.REDSTONE_WIRE;
        b &= world.getBlockState(pos.west()).getBlock() == redstone;
        b &= world.getBlockState(pos.east()).getBlock() == redstone;
        b &= world.getBlockState(pos.south()).getBlock() == redstone;
        b &= world.getBlockState(pos.north()).getBlock() == redstone;
        b &= world.getBlockState(pos.add(-1, 0, -1)).getBlock() == redstone;
        b &= world.getBlockState(pos.add(-1, 0, 1)).getBlock() == redstone;
        b &= world.getBlockState(pos.add(1, 0, -1)).getBlock() == redstone;
        b &= world.getBlockState(pos.add(1, 0, 1)).getBlock() == redstone;
        for (int dx = pos.getX() - 3; dx <= pos.getX() + 3; ++dx) {
            for (int dz = pos.getZ() - 3; dz <= pos.getZ() + 3; ++dz) {
                BlockPos p = new BlockPos(dx, pos.getY(), dz);
                if (!world.getBlockState(p.down()).isNormalCube()) {
                    return false;
                }
                if (!world.isAirBlock(p.up())) {
                    return false;
                }
                if (world.isAirBlock(p.up(2))) continue;
                return false;
            }
        }
        return b;
    }

    public static void handleCreatureDeath(World world, EntityPlayer player, EntityLivingBase victim) {
        if (victim instanceof EntityChicken && player.getHeldItemMainhand().getItem() == WitcheryGeneralItems.BOLINE) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.inventory.getStackInSlot(i);
                if (stack.isEmpty() || !(stack.getItem() instanceof ItemGlassGoblet)) continue;
                int x = MathHelper.floor((double)victim.posX);
                int y = MathHelper.floor((double)victim.posY);
                int z = MathHelper.floor((double)victim.posZ);
                for (int dx = x - 1; dx <= x + 1; ++dx) {
                    for (int dz = z - 1; dz <= z + 1; ++dz) {
                        for (int dy = y - 1; dy <= y + 1; ++dy) {
                            if (!ItemGlassGoblet.isRitual(world, new BlockPos(dx, dy, dz))) continue;
                            player.inventory.setInventorySlotContents(i, ((ItemGlassGoblet)stack.getItem()).getNewGoblet(stack, (Entity)victim));
                            world.playSound(null, victim.posX, victim.posY + (double)(victim.height * 0.85f), victim.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(victim.posX, victim.posY + (double)(victim.height * 0.85f), victim.posZ, 0.5f, 0.5f, EnumParticleTypes.REDSTONE), world, victim.posX, victim.posY + (double)(victim.height * 0.85f), victim.posZ);
                            return;
                        }
                    }
                }
                break;
            }
        }
    }

    public static void onEntityInteract(World world, EntityPlayer player, ItemStack stack, PlayerInteractEvent.EntityInteract event) {
        if (!event.getEntityPlayer().world.isRemote && ((ItemGlassGoblet)stack.getItem()).isFull && !CreatureUtil.isWerewolf(event.getTarget(), true) && !CreatureUtil.isVampire(event.getTarget())) {
            EntityVillageGuard entity2;
            boolean success = false;
            if (event.getTarget() instanceof EntityVillager) {
                EntityVillager entity = (EntityVillager)event.getTarget();
                if (ItemGlassGoblet.tryConvertToVampire((EntityLiving)entity, WitcheryDataExtensions.VILLAGER.get(entity).getBlood(), player, stack)) {
                    success = true;
                }
            } else if (event.getTarget() instanceof EntityVillageGuard && ItemGlassGoblet.tryConvertToVampire((EntityLiving)(entity2 = (EntityVillageGuard)event.getTarget()), entity2.getBlood(), player, stack)) {
                success = true;
            }
            if (success) {
                world.playSound(null, event.getTarget().getPosition(), WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(event.getTarget().posX, event.getTarget().posY, event.getTarget().posZ, event.getTarget().width, event.getTarget().height, EnumParticleTypes.REDSTONE), event.getTarget());
                player.setHeldItem(event.getHand(), ((ItemGlassGoblet)stack.getItem()).getNewGoblet(stack, null));
            } else {
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
            event.setCanceled(true);
        }
    }

    public ItemStack getNewGoblet(ItemStack oldStack, Entity entity) {
        if (entity != null) {
            return this.updateBloodOwner(new ItemStack((Item)WitcheryGeneralItems.FULL_GLASS_GOBLET, oldStack.getCount()), entity, 0);
        }
        return new ItemStack((Item)WitcheryGeneralItems.GLASS_GOBLET, oldStack.getCount());
    }

    private static boolean isCoffinNear(World world, Entity entity) {
        BlockPos entityPosition = entity.getPosition();
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)entityPosition.add(-4, -4, -4), (BlockPos)entityPosition.add(4, 4, 4))) {
            if (!(world.getBlockState(pos).getBlock() instanceof BlockCoffin)) continue;
            return true;
        }
        return false;
    }

    private static void convertToVampire(EntityLiving entity) {
        EntityVampire vampire = new EntityVampire(entity.world);
        vampire.enablePersistence();
        vampire.copyLocationAndAnglesFrom((Entity)entity);
        vampire.onInitialSpawn(entity.world.getDifficultyForLocation(entity.getPosition()), null);
        entity.world.removeEntity((Entity)entity);
        entity.world.spawnEntity((Entity)vampire);
        entity.world.playEvent(1017, vampire.getPosition(), 0);
    }

    private boolean hasChickenBlood(ItemStack stack) {
        return this.getEntityType(stack, 0) == EntityChicken.class;
    }

    public ItemStack onItemUseFinish(ItemStack stack, World world, EntityLivingBase entity) {
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
            if (!this.isFull) {
                if (transformation.getLevel() >= 9) {
                    if (transformation.decreaseBlood(125, true)) {
                        playerEx.sync();
                        world.playSound(null, player.posX, player.posY + (double)(player.height * 0.85f), player.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, entity.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(player.posX, player.posY + (double)(player.height * 0.85f), player.posZ, 0.8f, 0.3f, EnumParticleTypes.REDSTONE), world, player.posX, player.posY + (double)(player.height * 0.85f), player.posZ);
                        return this.getNewGoblet(stack, (Entity)player);
                    }
                    player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".needs_blood", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                } else if (playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                    player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".not_master", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                } else {
                    player.sendMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".failed", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_BURP, player.getSoundCategory(), 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
                if (!playerEx.isTransformation(WitcheryTransformations.VAMPIRE) && !this.hasChickenBlood(stack)) {
                    if (!WitcheryConfigOptions.allowVampireWolfHybrids && playerEx.isTransformation(WitcheryTransformations.WEREWOLF)) {
                        player.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.hybridsnotallow", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                        return stack;
                    }
                    if (transformation.getBloodPower() == 0) {
                        transformation.setLevel(1);
                        playerEx.sync();
                        player.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.8f, 1.5f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                    } else if (CreatureUtil.isInSunlight((EntityLivingBase)player)) {
                        player.setFire(5);
                    } else {
                        player.addPotionEffect(new PotionEffect(MobEffects.HUNGER, 600));
                        player.addPotionEffect(new PotionEffect(MobEffects.STRENGTH, 600, 1));
                    }
                }
                return this.getNewGoblet(stack, null);
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult mop = OtherwhereInfusion.raytraceBlocks(world, player, true, 2.0);
        ItemStack stack = player.getHeldItem(hand);
        if (mop != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && world.getBlockState(mop.getBlockPos()).getBlock() == Blocks.SKULL) {
            TileEntitySkull skull = (TileEntitySkull)world.getTileEntity(mop.getBlockPos());
            if (!world.isRemote && skull != null && skull.getSkullType() == 0) {
                if (this.hasChickenBlood(stack) && world.provider.canRespawnHere() && ItemGlassGoblet.isRitual(world, mop.getBlockPos()) && world.canSeeSky(mop.getBlockPos()) && !world.isDaytime() && WitcheryConfigOptions.allowVampireRitual && !this.isElleNear(world, mop.getBlockPos().down())) {
                    stack = this.getNewGoblet(stack, null);
                    player.setHeldItem(hand, stack);
                    EntityLightningBolt bolt = new EntityLightningBolt(world, 0.5 + (double)mop.getBlockPos().getX(), (double)mop.getBlockPos().getY() + 0.05, 0.5 + (double)mop.getBlockPos().getZ(), true);
                    world.setBlockToAir(mop.getBlockPos());
                    world.addWeatherEffect((Entity)bolt);
                    EntityElle elle = WitcheryEntities.ELLE.create(world);
                    if (elle != null) {
                        elle.enablePersistence();
                        elle.setPositionAndRotation(0.5 + (double)mop.getBlockPos().getX(), (double)mop.getBlockPos().getY() + 1.05, 0.5 + (double)mop.getBlockPos().getZ(), 0.0f, 0.0f);
                        elle.setOwnerId(player.getUniqueID());
                        elle.setTamed(true);
                        world.setEntityState((Entity)elle, (byte)7);
                        world.playSound(null, 0.5 + (double)mop.getBlockPos().getX(), (double)mop.getBlockPos().getY() + 1.05, 0.5 + (double)mop.getBlockPos().getZ(), WitcherySounds.ENTITY_LILITH_AMBIENT, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)mop.getBlockPos().getX(), (double)mop.getBlockPos().getY() + 1.05, 0.5 + (double)mop.getBlockPos().getZ(), 1.0f, 2.0f, EnumParticleTypes.REDSTONE), world, mop.getBlockPos().up());
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.start", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                        world.spawnEntity((Entity)elle);
                    }
                } else {
                    player.sendStatusMessage(new TextComponentTranslation(WitcheryGeneralItems.GLASS_GOBLET.getTranslationKey() + ".something_wrong", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

