/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016JH\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010)\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0011\u00a8\u0006,"}, d2={"Lnet/msrandom/witchery/item/ItemEndlessWaterBrew;", "Lnet/minecraft/item/Item;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getDurabilityForDisplay", "", "getRemaining", "", "getUsedAmount", "hasEffect", "", "initCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "face", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "showDurabilityBar", "use", "amount", "FluidHandler", "WitcheryResurrected"})
public final class ItemEndlessWaterBrew
extends Item {
    public boolean hasEffect(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public EnumActionResult onItemUse(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)face, (String)"face");
        BlockPos placementPosition = pos;
        ItemStack itemStack = stack = player.getHeldItem(hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        if (this.getRemaining(itemStack) >= 1000) {
            IBlockState state;
            IBlockState iBlockState = state = world.getBlockState(placementPosition);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            Block block = iBlockState.getBlock();
            if (block == Blocks.CAULDRON) {
                if (!world.isRemote && Intrinsics.compare((int)((Number)((Object)state.getValue((IProperty)BlockCauldron.LEVEL))).intValue(), (int)3) < 0) {
                    int n = this.getRemaining(stack);
                    Comparable comparable = state.getValue((IProperty)BlockCauldron.LEVEL);
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(BlockCauldron.LEVEL)");
                    this.use(player, stack, RangesKt.coerceAtMost((int)n, (int)MathKt.roundToInt((float)((float)(3 - ((Number)((Object)comparable)).intValue()) * 333.33334f))));
                    Blocks.CAULDRON.setWaterLevel(world, placementPosition, state, 3);
                    world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                EnumActionResult enumActionResult;
                TileEntity tileEntity = world.getTileEntity(placementPosition);
                if (tileEntity instanceof IFluidHandler) {
                    int used = ((IFluidHandler)tileEntity).fill(new FluidStack(FluidRegistry.WATER, 3000), true);
                    if (used > 0) {
                        this.use(player, stack, used);
                        world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        tileEntity.markDirty();
                        enumActionResult = EnumActionResult.SUCCESS;
                    } else {
                        enumActionResult = EnumActionResult.FAIL;
                    }
                } else {
                    Material material;
                    IBlockState iblockstate;
                    BlockPos blockPos = placementPosition.offset(face);
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"placementPosition.offset(face)");
                    placementPosition = blockPos;
                    IBlockState iBlockState2 = iblockstate = world.getBlockState(placementPosition);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"iblockstate");
                    Material material2 = material = iBlockState2.getMaterial();
                    Intrinsics.checkExpressionValueIsNotNull((Object)material2, (String)"material");
                    boolean flag = !material2.isSolid();
                    boolean flag1 = iblockstate.getBlock().isReplaceable((IBlockAccess)world, placementPosition);
                    if (!(world.isAirBlock(placementPosition) || flag || flag1)) {
                        enumActionResult = EnumActionResult.FAIL;
                    } else {
                        if (world.provider.doesWaterVaporize()) {
                            int l = placementPosition.getX();
                            int i = placementPosition.getY();
                            int j = placementPosition.getZ();
                            world.playSound(player, placementPosition, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                            int n = 0;
                            int n2 = 7;
                            while (n <= n2) {
                                void k;
                                world.spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                                ++k;
                            }
                        } else {
                            if (!world.isRemote && (flag || flag1) && !material.isLiquid()) {
                                world.destroyBlock(placementPosition, true);
                            }
                            this.use(player, stack, 1000);
                            world.playSound(player, placementPosition, SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            BlockDynamicLiquid blockDynamicLiquid = Blocks.FLOWING_WATER;
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockDynamicLiquid, (String)"Blocks.FLOWING_WATER");
                            world.setBlockState(placementPosition, blockDynamicLiquid.getDefaultState(), 11);
                        }
                        enumActionResult = EnumActionResult.SUCCESS;
                    }
                }
                return enumActionResult;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return WitcheryUtils.getOrCreateTag(stack).getInteger("Amount") != 0;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return (double)WitcheryUtils.getOrCreateTag(stack).getInteger("Amount") / 300000.0;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.addInformation(stack, worldIn, tooltip, flagIn);
        String string = I18n.format((String)(this.getTranslationKey() + ".tip"), (Object[])new Object[]{"" + TextFormatting.AQUA + this.getRemaining(stack) / 1000 + TextFormatting.GRAY, TextFormatting.AQUA + "300" + TextFormatting.GRAY});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"I18n.format(\"$translatio\u20260${TextFormatting.GRAY}\")");
        tooltip.add(string);
    }

    @NotNull
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return new FluidHandler(stack);
    }

    public final void use(@Nullable EntityPlayer player, @NotNull ItemStack stack, int amount) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (player == null || !player.capabilities.isCreativeMode) {
            NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack);
            int newAmount = tag.getInteger("Amount") + amount;
            tag.setInteger("Amount", newAmount);
            if (newAmount >= 300000) {
                stack.shrink(1);
            }
        }
    }

    public final int getRemaining(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 300000 - this.getUsedAmount(stack);
    }

    public final int getUsedAmount(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return WitcheryUtils.getOrCreateTag(stack).getInteger("Amount");
    }

    public ItemEndlessWaterBrew() {
        this.setMaxStackSize(1);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.addPropertyOverride(new ResourceLocation("witchery", "emptiness"), new IItemPropertyGetter(){

            public final float apply(ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                float f = 1.0f;
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                return f - (float)this.getRemaining(itemStack) / 300000.0f;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J-\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u000b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/msrandom/witchery/item/ItemEndlessWaterBrew$FluidHandler;", "Lnet/minecraftforge/fluids/capability/IFluidHandlerItem;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "container", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "", "doDrain", "", "resource", "fill", "doFill", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getContainer", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/FluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/FluidTankProperties;", "hasCapability", "WitcheryResurrected"})
    private static final class FluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private ItemStack container;

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this) : null);
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }

        @NotNull
        public FluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, 3000), 300000, false, true)};
        }

        public int fill(@NotNull FluidStack resource, boolean doFill) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            return 0;
        }

        @Nullable
        public FluidStack drain(@NotNull FluidStack resource, boolean doDrain) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            return resource.getFluid() != FluidRegistry.WATER ? null : this.drain(resource.amount, doDrain);
        }

        @NotNull
        public FluidStack drain(int maxDrain, boolean doDrain) {
            Item item = this.container.getItem();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.ItemEndlessWaterBrew");
            }
            int drainAmount = RangesKt.coerceAtMost((int)((ItemEndlessWaterBrew)item).getRemaining(this.getContainer()), (int)maxDrain);
            if (doDrain) {
                Item item2 = this.container.getItem();
                if (item2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.ItemEndlessWaterBrew");
                }
                ((ItemEndlessWaterBrew)item2).use(null, this.getContainer(), drainAmount);
            }
            return new FluidStack(FluidRegistry.WATER, drainAmount);
        }

        public FluidHandler(@NotNull ItemStack container) {
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            this.container = container;
        }
    }
}

