/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityBroom;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0004\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/item/ItemEnchantedBroom;", "Lnet/minecraft/item/Item;", "()V", "getColor", "Lnet/minecraft/item/EnumDyeColor;", "stack", "Lnet/minecraft/item/ItemStack;", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "hasEffect", "", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "setBroomEntityColor", "", "broomEntity", "Lnet/msrandom/witchery/entity/EntityBroom;", "itemstack", "setColor", "color", "WitcheryResurrected"})
public final class ItemEnchantedBroom
extends Item {
    @NotNull
    public EnumActionResult onItemUse(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult enumActionResult;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack stack = player.getHeldItem(hand);
        double x = player.prevPosX + (player.posX - player.prevPosX);
        double y = player.prevPosY + (player.posY - player.prevPosY) + (double)player.getEyeHeight();
        double z = player.prevPosZ + (player.posZ - player.prevPosZ);
        Vec3d playerPosition = new Vec3d(x, y, z);
        Vec3d look = player.getLook(1.0f);
        boolean colliding = false;
        for (Entity entity : world.getEntitiesWithinAABBExcludingEntity((Entity)player, player.getEntityBoundingBox().expand(look.x * 5.0, look.y * 5.0, look.z * 5.0).grow(1.0))) {
            if (!entity.canBeCollidedWith()) continue;
            Entity entity2 = entity;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
            if (!entity2.getEntityBoundingBox().grow((double)entity.getCollisionBorderSize()).contains(playerPosition)) continue;
            colliding = true;
        }
        if (colliding) {
            EnumActionResult enumActionResult2 = super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
            Intrinsics.checkExpressionValueIsNotNull((Object)enumActionResult2, (String)"super.onItemUse(player, \u2026facing, hitX, hitY, hitZ)");
            return enumActionResult2;
        }
        BlockPos position = pos.offset(facing);
        IBlockState iBlockState = world.getBlockState(position);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(position)");
        if (Intrinsics.areEqual((Object)iBlockState.getBlock(), (Object)Blocks.SNOW)) {
            position = position.down();
        }
        BlockPos blockPos = position;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"position");
        EntityBroom broomEntity = new EntityBroom(world, (double)blockPos.getX() + 0.5, (double)position.getY() + 1.0, (double)position.getZ() + 0.5);
        if (stack.hasDisplayName()) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            broomEntity.setCustomNameTag(itemStack.getDisplayName());
        }
        ItemStack itemStack = stack;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        this.setBroomEntityColor(broomEntity, itemStack);
        broomEntity.rotationYaw = player.rotationYaw;
        if (world.getCollisionBoxes((Entity)broomEntity, broomEntity.getEntityBoundingBox().expand(-0.1, -0.1, -0.1)).isEmpty()) {
            broomEntity.rotationYaw = player.rotationYaw;
            if (!world.isRemote) {
                world.spawnEntity((Entity)broomEntity);
            }
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            player.addStat(StatList.getObjectUseStats((Item)this));
            enumActionResult = EnumActionResult.SUCCESS;
        } else {
            enumActionResult = EnumActionResult.FAIL;
        }
        return enumActionResult;
    }

    private final void setBroomEntityColor(EntityBroom broomEntity, ItemStack itemstack) {
        broomEntity.setBrushColor(this.getColor(itemstack));
    }

    public final void setColor(@NotNull ItemStack stack, @NotNull EnumDyeColor color2) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)color2, (String)"color");
        WitcheryUtils.getOrCreateTag(stack).setByte("BrushColor", (byte)color2.getMetadata());
    }

    @NotNull
    public final EnumDyeColor getColor(@NotNull ItemStack stack) {
        NBTTagCompound tag;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.hasTagCompound() && (tag = WitcheryUtils.getOrCreateTag(stack)).hasKey("BrushColor")) {
            EnumDyeColor enumDyeColor = EnumDyeColor.byMetadata((int)tag.getByte("BrushColor"));
            Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(\u2026te(\"BrushColor\").toInt())");
            return enumDyeColor;
        }
        return EnumDyeColor.BROWN;
    }

    public boolean hasEffect(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumRarity.EPIC;
    }

    public ItemEnchantedBroom() {
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }
}

