/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelEarmuffs;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemEarmuffs
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelEarmuffs model;

    public ItemEarmuffs(EntityEquipmentSlot armorSlot) {
        super(ItemArmor.ArmorMaterial.LEATHER, 1, armorSlot);
        this.setMaxDamage(ItemArmor.ArmorMaterial.LEATHER.getDurability(armorSlot));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean isHelmWorn(EntityPlayer entity) {
        ItemStack currentArmor = entity.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
        return currentArmor.getItem() == WitcheryEquipmentItems.EARMUFFS;
    }

    public boolean hasColor(ItemStack stack) {
        return false;
    }

    public int getColor(ItemStack stack) {
        if (!this.hasColor(stack)) {
            return 0xFFFFFF;
        }
        return super.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.COMMON;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        if (!stack.isEmpty()) {
            String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (stack.isEmpty()) {
            return null;
        }
        if (type == null) {
            return "witchery:textures/entities/earmuffs.png";
        }
        return "witchery:textures/entities/empty64x64_overlay.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.model == null) {
            this.model = new ModelEarmuffs();
        }
        return this.model;
    }
}

