/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class ItemDiviner
extends Item {
    private static final int MAX_DAMAGE = 50;
    private static final int DAMAGE_PER_USE = 1;
    private final Block blockToDetect;

    public ItemDiviner(Block blockToDetect) {
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.blockToDetect = blockToDetect;
        this.setMaxStackSize(1);
        this.setMaxDamage(50);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 400;
    }

    public void onUsingTick(ItemStack itemstack, EntityLivingBase player, int countdown) {
        World world = player.world;
        if (player instanceof EntityPlayer && !world.isRemote) {
            int elapsedTicks = this.getMaxItemUseDuration(itemstack) - countdown;
            RayTraceResult mop = OtherwhereInfusion.doCustomRayTrace(world, (EntityPlayer)player, true, 6.0);
            if (mop == null || mop.typeOfHit != RayTraceResult.Type.BLOCK || mop.sideHit != EnumFacing.UP) {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                player.resetActiveHand();
                return;
            }
            int posX = MathHelper.floor((float)mop.getBlockPos().getX());
            int posY = MathHelper.floor((float)mop.getBlockPos().getY()) - elapsedTicks;
            int posZ = MathHelper.floor((float)mop.getBlockPos().getZ());
            Block block = world.getBlockState(new BlockPos(posX, posY, posZ)).getBlock();
            boolean foundBlock = false;
            boolean foundSomething = false;
            if (block == this.blockToDetect) {
                foundBlock = true;
                foundSomething = true;
            } else if (block == Blocks.BEDROCK) {
                foundSomething = true;
            }
            if (foundSomething || posY <= 1) {
                world.playSound(null, mop.getBlockPos(), foundBlock ? SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP : SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)mop.getBlockPos().getX() + 0.5, (double)mop.getBlockPos().getY(), (double)mop.getBlockPos().getZ() + 0.5, 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), world, mop.getBlockPos(), 8.0);
                player.resetActiveHand();
                itemstack.damageItem(1, player);
            }
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }
}

