/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/item/ItemDemonicBlood;", "Lnet/minecraft/item/Item;", "()V", "onItemUse", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "WitcheryResurrected"})
public final class ItemDemonicBlood
extends Item {
    @NotNull
    public EnumActionResult onItemUse(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        if (!world.isRemote) {
            IBlockState iBlockState = world.getBlockState(pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
            if (iBlockState.getBlock() == WitcheryBlocks.PLAIN_WICKER_BUNDLE) {
                int uses = 5;
                BlockPos blockPos = pos.add(-1, -1, -1);
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.add(-1, -1, -1)");
                BlockPos blockPos2 = pos.add(1, 1, 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.add(1, 1, 1)");
                for (BlockPos p : WitcheryUtils.rangeTo(blockPos, blockPos2)) {
                    IBlockState state;
                    if (uses <= 0) break;
                    IBlockState iBlockState2 = state = world.getBlockState(p);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state");
                    if (iBlockState2.getBlock() != WitcheryBlocks.PLAIN_WICKER_BUNDLE) continue;
                    world.setBlockState(p, WitcheryBlocks.BLOODIED_WICKER_BUNDLE.getDefaultState().withProperty((IProperty)BlockRotatedPillar.AXIS, state.getValue((IProperty)BlockRotatedPillar.AXIS)), 3);
                    --uses;
                }
                player.getHeldItem(hand).shrink(1);
                return EnumActionResult.SUCCESS;
            }
        }
        EnumActionResult enumActionResult = super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumActionResult, (String)"super.onItemUse(player, \u2026facing, hitX, hitY, hitZ)");
        return enumActionResult;
    }
}

