/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.client.model.ModelClothesDeath;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemDeathsClothes
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelClothesDeath model;

    public ItemDeathsClothes(EntityEquipmentSlot armorSlot) {
        super(ItemArmor.ArmorMaterial.IRON, 1, armorSlot);
        this.setMaxDamage(ItemArmor.ArmorMaterial.DIAMOND.getDurability(armorSlot));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean isFullSetWorn(EntityLivingBase entity) {
        int count = 0;
        for (int i = 2; i <= 5; ++i) {
            ItemStack item = entity.getItemStackFromSlot(EntityEquipmentSlot.values()[i]);
            if (!(item.getItem() instanceof ItemDeathsClothes)) continue;
            ++count;
        }
        return count >= 3;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (!stack.isEmpty()) {
            return "witchery:textures/entities/deathsclothes" + (type == null ? "" : "_overlay") + ".png";
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.isRemote && player.inventory.armorInventory.get(3) == stack) {
            PotionEffect potion;
            int offset = (int)(world.getTotalWorldTime() % 10L);
            if (WitcheryConfigOptions.allowDeathsHoodToFreezeVictims && offset == 1) {
                EntityLivingBase victim;
                RayTraceResult mop = OtherwhereInfusion.raytraceEntities(world, player, 16.0);
                if (mop != null && mop.typeOfHit == RayTraceResult.Type.ENTITY && mop.entityHit instanceof EntityLivingBase && (victim = (EntityLivingBase)mop.entityHit).canEntityBeSeen((Entity)player) && !victim.isPotionActive(MobEffects.SLOWNESS)) {
                    victim.addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 60, 2));
                }
            } else if (offset == 2 && world.getLight(player.getPosition()) < 8 && ((potion = player.getActivePotionEffect(MobEffects.NIGHT_VISION)) == null || potion.getDuration() <= 300)) {
                player.removePotionEffect(MobEffects.NIGHT_VISION);
                player.addPotionEffect(new PotionEffect(MobEffects.NIGHT_VISION, 400, 0, true, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.model == null) {
            this.model = new ModelClothesDeath();
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return super.getItemStackDisplayName(stack);
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advancedTooltips) {
        if (!stack.isEmpty() && (stack.getItem() != WitcheryEquipmentItems.DEATH_HOOD || WitcheryConfigOptions.allowDeathsHoodToFreezeVictims)) {
            String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }
}

