/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCoffin;

public class ItemCoffin
extends ItemBlock {
    public ItemCoffin(Block block) {
        super(block);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.getBlockState(pos);
        Block block = iblockstate.getBlock();
        boolean flag = block.isReplaceable((IBlockAccess)world, pos);
        if (!flag) {
            pos = pos.up();
        }
        EnumFacing enumfacing = player.getHorizontalFacing();
        BlockPos blockpos = pos.offset(enumfacing);
        ItemStack stack = player.getHeldItem(hand);
        if (player.canPlayerEdit(pos, facing, stack) && player.canPlayerEdit(blockpos, facing, stack)) {
            IBlockState iblockstate1 = world.getBlockState(blockpos);
            boolean flag1 = iblockstate1.getBlock().isReplaceable((IBlockAccess)world, blockpos);
            boolean flag2 = flag || world.isAirBlock(pos);
            boolean flag3 = flag1 || world.isAirBlock(blockpos);
            BlockPos posDown = pos.down();
            BlockPos blockposDown = blockpos.down();
            if (flag2 && flag3 && world.getBlockState(posDown).isSideSolid((IBlockAccess)world, posDown, EnumFacing.UP) && world.getBlockState(blockposDown).isSideSolid((IBlockAccess)world, blockposDown, EnumFacing.UP)) {
                IBlockState iblockstate2 = this.block.getDefaultState().withProperty((IProperty)BlockBed.OCCUPIED, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)BlockHorizontal.FACING, (Comparable)enumfacing).withProperty((IProperty)BlockCoffin.PART, (Comparable)BlockBed.EnumPartType.FOOT);
                world.setBlockState(pos, iblockstate2, 10);
                world.setBlockState(blockpos, iblockstate2.withProperty((IProperty)BlockCoffin.PART, (Comparable)BlockBed.EnumPartType.HEAD), 10);
                SoundType soundtype = iblockstate2.getBlock().getSoundType(iblockstate2, world, pos, (Entity)player);
                world.playSound(null, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                world.notifyNeighborsRespectDebug(pos, block, false);
                world.notifyNeighborsRespectDebug(blockpos, iblockstate1.getBlock(), false);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)player, pos, stack);
                }
                stack.shrink(1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }
}

