/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.BlockUtil;

public class ItemChalk
extends ItemBlock {
    public ItemChalk(Block block) {
        super(block);
        this.setMaxDamage(64);
        this.setNoRepair();
    }

    public static boolean drawGlyph(World world, BlockPos pos, EnumFacing side, Block block, EntityPlayer player) {
        boolean chalkUsed = false;
        if (block != WitcheryBlocks.CIRCLE) {
            Block overBlock = world.getBlockState(pos).getBlock();
            if (overBlock == block) {
                world.setBlockState(pos, overBlock.getDefaultState().withProperty(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.rand))), 3);
                chalkUsed = true;
            } else if (overBlock == WitcheryBlocks.GLYPH_RITUAL || overBlock == WitcheryBlocks.GLYPH_OTHERWHERE || overBlock == WitcheryBlocks.GLYPH_INFERNAL) {
                world.setBlockState(pos, block.getDefaultState().withProperty(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.rand))), 3);
                chalkUsed = true;
            } else if (side == EnumFacing.UP && WitcheryBlocks.GLYPH_RITUAL.canPlaceBlockAt(world, pos.up()) && BlockUtil.isReplaceableBlock(world, pos.up(), (EntityLivingBase)player)) {
                world.setBlockState(pos.up(), block.getDefaultState().withProperty(BlockCircleGlyph.GLYPH, (Comparable)((Object)BlockCircleGlyph.Type.getForPlacement(world.rand))), 3);
                chalkUsed = true;
            }
        } else if (world.getBlockState(pos).getBlock() != block && side == EnumFacing.UP && WitcheryBlocks.CIRCLE.canPlaceBlockAt(world, pos.up())) {
            world.setBlockState(pos.up(), block.getDefaultState());
            chalkUsed = true;
        }
        if (chalkUsed) {
            world.playSound(null, pos, WitcherySounds.ITEM_CHALK_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return chalkUsed;
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.isItemDamaged() ? 1 : 64;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            ItemStack stack = player.getHeldItem(hand);
            boolean chalkUsed = ItemChalk.drawGlyph(world, pos, side, this.block, player);
            if (chalkUsed) {
                if (!player.capabilities.isCreativeMode) {
                    stack.damageItem(1, (EntityLivingBase)player);
                    if (stack.getCount() > 1) {
                        ItemStack newStack = stack.copy();
                        newStack.shrink(1);
                        newStack.setItemDamage(0);
                        if (!player.inventory.addItemStackToInventory(newStack)) {
                            player.dropItem(newStack, false);
                        }
                        stack.setCount(1);
                    }
                }
            } else {
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

