/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemCaneSword
extends ItemSword {
    private final boolean sheathed;

    public ItemCaneSword(boolean sheathed) {
        super(Item.ToolMaterial.DIAMOND);
        this.sheathed = sheathed;
        this.setCreativeTab((CreativeTabs)(sheathed ? WitcheryGeneralItems.TAB : null));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public int getItemEnchantability() {
        return Item.ToolMaterial.IRON.getEnchantability();
    }

    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot slot) {
        HashMultimap multimap = HashMultimap.create((int)1, (int)1);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            if (this.sheathed) {
                multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", 1.0, 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)(this.getAttackDamage() + 4.0f), 0));
                multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", (double)-2.4f, 0));
            }
            return multimap;
        }
        return multimap;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (!world.isRemote) {
            if (player.isSneaking()) {
                NBTTagCompound tag = stack.getTagCompound();
                stack = new ItemStack((Item)(this.sheathed ? WitcheryGeneralItems.DRAWN_CANE_SWORD : WitcheryGeneralItems.SHEATHED_CANE_SWORD));
                stack.setTagCompound(tag);
                if (this.sheathed) {
                    world.playSound(null, player.getPosition(), WitcherySounds.ITEM_CANESWORD_SHEATHE, player.getSoundCategory(), 1.0f, 1.0f);
                } else {
                    world.playSound(null, player.getPosition(), WitcherySounds.ITEM_CANESWORD_DRAW, player.getSoundCategory(), 1.0f, 1.0f);
                }
            } else if (this.sheathed) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                if (transformation.getLevel() > 0 && transformation.getBloodReserve() > 0 && transformation.getBloodPower() < transformation.getMaxBloodPower()) {
                    world.playSound(null, player.posX, player.posY + (double)player.height * 0.85, player.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY + (double)player.height * 0.85, player.posZ, 0.5f, 0.5f, EnumParticleTypes.REDSTONE), (Entity)player);
                    transformation.useBloodReserve();
                    playerEx.sync();
                } else {
                    WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                return super.onItemRightClick(world, player, hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag moreTips) {
        String localText = WitcheryResurrected.translate(WitcheryGeneralItems.SHEATHED_CANE_SWORD.getTranslationKey() + ".tip", worldIn == null ? 0 : WitcheryUtils.getExtension((EntityPlayer)Minecraft.getMinecraft().player).getTransformation(WitcheryTransformations.VAMPIRE).getBloodReserve());
        if (localText != null) {
            for (String s : localText.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }
}

