/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.brewing.BrewNameBuilder;
import net.msrandom.witchery.brewing.BrewNamePart;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;

public class ItemBrewBottle
extends Item {
    public ItemBrewBottle() {
        this.setMaxStackSize(8);
    }

    public boolean hasEffect(ItemStack stack) {
        return true;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null) {
            return WitcheryBrewEffects.getBrewName(nbtRoot);
        }
        return super.getItemStackDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag expanded) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null) {
            BrewNameBuilder nameBuilder = new BrewNameBuilder(false);
            BrewActionList actionList = new BrewActionList(nbtRoot);
            int drinkSpeed = 32;
            for (BrewAction action : actionList.actions) {
                drinkSpeed += action.getDrinkSpeedModifiers();
            }
            drinkSpeed = Math.max(drinkSpeed, 2);
            for (BrewAction action : actionList.actions) {
                BrewNamePart name2 = action.getNamePart();
                if (name2 == null) continue;
                name2.applyTo(nameBuilder);
            }
            String tooltip = nameBuilder.toString();
            if (drinkSpeed != 32) {
                tooltip = drinkSpeed > 48 ? tooltip + I18n.format((String)"brew.witchery.quaffing", (Object[])new Object[]{I18n.format((String)"brew.witchery.quaffing.very_slow", (Object[])new Object[0])}) : (drinkSpeed > 32 ? tooltip + I18n.format((String)"brew.witchery.quaffing", (Object[])new Object[]{I18n.format((String)"brew.witchery.quaffing.slow", (Object[])new Object[0])}) : (drinkSpeed < 16 ? tooltip + I18n.format((String)"brew.witchery.quaffing", (Object[])new Object[]{I18n.format((String)"brew.witchery.quaffing.very_fast", (Object[])new Object[0])}) : tooltip + I18n.format((String)"brew.witchery.quaffing", (Object[])new Object[]{I18n.format((String)"brew.witchery.quaffing.fast", (Object[])new Object[0])})));
            }
            for (String s : tooltip.split("\n")) {
                if (s.isEmpty()) continue;
                list2.add(s);
            }
        }
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        int drinkSpeed = nbtRoot != null ? nbtRoot.getInteger("DrinkingSpeed") : 32;
        return drinkSpeed > 0 ? drinkSpeed : 32;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        player.setActiveHand(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
    }

    public ItemStack onItemUseFinish(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            if (!world.isRemote) {
                ModifiersEffect modifiers = new ModifiersEffect(1.0, 1.0, false, null, false, 0, player);
                WitcheryBrewEffects.applyToEntity(world, (EntityLivingBase)player, stack.getTagCompound(), modifiers);
            }
            if (!player.capabilities.isCreativeMode) {
                if (stack.isEmpty()) {
                    return new ItemStack(Items.GLASS_BOTTLE);
                }
                player.inventory.addItemStackToInventory(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        return stack;
    }
}

