/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Dyeable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.inventory.InventoryBrewBag;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketBrewPrepared;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class ItemBrewBag
extends Item
implements Dyeable {
    private static final float THRESHOLD_ORTHOGONAL = 7.0f;
    private static final float THRESHOLD_DIAGONAL = 3.5f;

    public ItemBrewBag() {
        this.setMaxStackSize(1);
        this.setFull3D();
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 36000;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCauldron cauldron;
        int i;
        ItemStack stack = player.getHeldItem(hand);
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == Blocks.CAULDRON && (i = ((Integer)state.getValue((IProperty)BlockCauldron.LEVEL)).intValue()) > 0) {
            if (this.hasColor(stack)) {
                this.removeColor(stack);
                Blocks.CAULDRON.setWaterLevel(world, pos, state, i - 1);
                return EnumActionResult.SUCCESS;
            }
        } else if (state.getBlock() == WitcheryBlocks.CAULDRON && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos)) != null && cauldron.drain(1000, true) != null) {
            if (this.hasColor(stack)) {
                this.removeColor(stack);
            } else {
                this.setColor(stack, cauldron.getColor());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        player.setActiveHand(hand);
        if (!player.isSneaking()) {
            NBTTagCompound nbtTag = player.getEntityData();
            nbtTag.setByteArray("Strokes", new byte[0]);
            nbtTag.setFloat("StartPitch", player.rotationPitch);
            nbtTag.setFloat("StartYaw", player.rotationYawHead);
            nbtTag.removeTag("WitcheryLastBrewIndex");
        } else {
            WitcheryUtils.openContainer(WitcheryContainers.getBrewBag(), player, BlockPos.ORIGIN, (ITextComponent)new TextComponentString(stack.getDisplayName()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int countdown) {
        if (player instanceof EntityPlayer) {
            NBTTagCompound nbtTag;
            if (player.world.isRemote) {
                NBTTagCompound tag = player.getEntityData();
                if (player.isSneaking()) {
                    tag.removeTag("Strokes");
                    tag.setFloat("StartPitch", player.rotationPitch);
                    tag.setFloat("StartYaw", player.rotationYawHead);
                    return;
                }
                float yawDiff = tag.getFloat("StartYaw") - player.rotationYawHead;
                float pitchDiff = tag.getFloat("StartPitch") - player.rotationPitch;
                if (!tag.hasKey("Stroke")) {
                    int stroke = -1;
                    if (pitchDiff >= 3.5f && yawDiff <= -3.5f) {
                        stroke = BranchStroke.DOWN_LEFT.ordinal();
                    } else if (pitchDiff >= 3.5f && yawDiff >= 3.5f) {
                        stroke = BranchStroke.UP_LEFT.ordinal();
                    } else if (pitchDiff <= -3.5f && yawDiff <= -3.5f) {
                        stroke = BranchStroke.DOWN_RIGHT.ordinal();
                    } else if (pitchDiff <= -3.5f && yawDiff >= 3.5f) {
                        stroke = BranchStroke.UP_RIGHT.ordinal();
                    } else if (pitchDiff >= 7.0f) {
                        stroke = BranchStroke.UP.ordinal();
                    } else if (pitchDiff <= -7.0f) {
                        stroke = BranchStroke.DOWN.ordinal();
                    } else if (yawDiff <= -7.0f) {
                        stroke = BranchStroke.RIGHT.ordinal();
                    } else if (yawDiff >= 7.0f) {
                        stroke = BranchStroke.LEFT.ordinal();
                    }
                    if (stroke != -1) {
                        tag.setFloat("StartPitch", player.rotationPitch);
                        tag.setFloat("StartYaw", player.rotationYawHead);
                        tag.setByte("Strokes", (byte)stroke);
                        int brewIndex = BranchStroke.VALUES[stroke].index();
                        InventoryBrewBag inv = new InventoryBrewBag((EntityPlayer)player);
                        ItemStack brew = inv.getStackInSlot(brewIndex);
                        if (!brew.isEmpty()) {
                            WitcheryNetworkChannel.sendToServer(new PacketBrewPrepared(brewIndex));
                            player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, player.getSoundCategory(), 1.0f, 0.4f / ((float)player.getRNG().nextDouble() * 0.4f + 0.8f));
                        } else {
                            tag.removeTag("Strokes");
                        }
                    }
                }
            } else if (player.isSneaking() && (nbtTag = player.getEntityData()).hasKey("WitcheryLastBrewIndex")) {
                nbtTag.removeTag("WitcheryLastBrewIndex");
            }
        }
    }

    public byte[] move(BranchStroke stroke, byte[] bytes) {
        bytes[0] = (byte)stroke.ordinal();
        return bytes;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound nbtTag = player.getEntityData();
            if (!world.isRemote && nbtTag.hasKey("WitcheryLastBrewIndex")) {
                int brewIndex = nbtTag.getInteger("WitcheryLastBrewIndex");
                nbtTag.removeTag("WitcheryLastBrewIndex");
                if (!player.isSneaking()) {
                    if (brewIndex > -1) {
                        InventoryBrewBag inv = new InventoryBrewBag(player);
                        ItemStack brew = inv.getStackInSlot(brewIndex);
                        if (!brew.isEmpty()) {
                            if (brew.getItem() == WitcheryGeneralItems.SPLASH_BREW_BOTTLE || brew.getItem() == WitcheryGeneralItems.LINGERING_BREW_BOTTLE) {
                                if (!player.capabilities.isCreativeMode) {
                                    brew.shrink(1);
                                }
                                world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, player.getSoundCategory(), 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
                                EntityBrew brewEntity = new EntityBrew(world, (EntityLivingBase)player, brew, false);
                                brewEntity.shoot((Entity)player, player.rotationPitch, player.rotationYaw, -20.0f, 0.75f, 1.0f);
                                world.spawnEntity((Entity)brewEntity);
                            } else {
                                ItemKettleBrew.Companion.throwStack(world, player, brew);
                            }
                            inv.writeToNBT();
                        }
                    } else {
                        player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.getRNG().nextDouble() * 0.4f + 0.8f));
                    }
                }
            } else {
                nbtTag.removeTag("Strokes");
                nbtTag.removeTag("StartYaw");
                nbtTag.removeTag("StartPitch");
            }
        }
    }
}

