/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.msrandom.witchery.block.BlockCrystalBall;
import net.msrandom.witchery.entity.EntityEye;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.network.PacketEyePosition;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JH\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0011H\u0016J \u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006)"}, d2={"Lnet/msrandom/witchery/item/ItemBoundWaystone;", "Lnet/minecraft/item/Item;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getForgeRarity", "Lnet/minecraft/item/EnumRarity;", "getMaxItemUseDuration", "", "onItemUseFinish", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "onItemUseFirst", "Lnet/minecraft/util/EnumActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "pos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "hand", "Lnet/minecraft/util/EnumHand;", "onPlayerStoppedUsing", "timeLeft", "onUsingTick", "countdown", "stop", "WitcheryResurrected"})
public final class ItemBoundWaystone
extends Item {
    @NotNull
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        IBlockState state = world.getBlockState(pos);
        ItemStack stack = player.getHeldItem(hand);
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        if (WitcheryUtils.isOf(iBlockState, (Block)WitcheryBlocks.CRYSTAL_BALL)) {
            if (!world.isRemote && BlockCrystalBall.tryConsumePower(world, player, pos)) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                NBTTagCompound tag = itemStack.getTagCompound();
                if (tag != null) {
                    if (tag.getInteger("Dimension") == player.dimension && player.getDistanceSq((double)tag.getInteger("X"), (double)tag.getInteger("Y"), (double)tag.getInteger("Z")) <= (double)22500) {
                        player.setActiveHand(hand);
                    } else {
                        world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    }
                } else {
                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else if (world.isRemote) {
                player.setActiveHand(hand);
            }
            return !world.isRemote ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        EnumActionResult enumActionResult = super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumActionResult, (String)"super.onItemUseFirst(pla\u2026, hitX, hitY, hitZ, hand)");
        return enumActionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int countdown) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.onUsingTick(stack, player, countdown);
        int elapsedTicks = stack.getMaxItemUseDuration() - countdown;
        if (player instanceof EntityPlayerMP && elapsedTicks == 0) {
            NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack);
            EntityEye eye = new EntityEye(player.world);
            eye.setLocationAndAngles(tag.getInteger("X"), tag.getInteger("Y"), tag.getInteger("Z"), player.rotationYaw, 90.0f);
            player.world.spawnEntity((Entity)eye);
            WitcheryNetworkChannel.sendTo(new PacketEyePosition((Entity)eye, true), (EntityPlayerMP)player);
        }
    }

    public void onPlayerStoppedUsing(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull EntityLivingBase entity, int timeLeft) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super.onPlayerStoppedUsing(stack, worldIn, entity, timeLeft);
        this.stop(entity);
    }

    @NotNull
    public ItemStack onItemUseFinish(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull EntityLivingBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.stop(entity);
        ItemStack itemStack = super.onItemUseFinish(stack, worldIn, entity);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"super.onItemUseFinish(stack, worldIn, entity)");
        return itemStack;
    }

    private final void stop(EntityLivingBase entity) {
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketEyePosition(null, false), (EntityPlayerMP)entity);
        }
    }

    public int getMaxItemUseDuration(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return 1200;
    }

    public void addInformation(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        super.addInformation(stack, worldIn, tooltip, flagIn);
        NBTTagCompound tag = stack.getTagCompound();
        if (tag != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s: %d, %d, %d";
            Object[] objectArray = new Object[4];
            DimensionType dimensionType = DimensionManager.getProviderType((int)tag.getInteger("Dimension"));
            Intrinsics.checkExpressionValueIsNotNull((Object)dimensionType, (String)"DimensionManager.getProv\u2026.getInteger(\"Dimension\"))");
            objectArray[0] = WitcheryUtils.getFormattedName(dimensionType);
            objectArray[1] = tag.getInteger("X");
            objectArray[2] = tag.getInteger("Y");
            objectArray[3] = tag.getInteger("Z");
            Object[] objectArray2 = objectArray;
            List<String> list2 = tooltip;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            list2.add(string3);
        }
    }

    @NotNull
    public EnumRarity getForgeRarity(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return EnumRarity.UNCOMMON;
    }
}

