/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockPlantMine;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class ItemBoline
extends ItemSword {
    public static final Block[] blocksEffectiveAgainst = new Block[]{Blocks.PLANKS, Blocks.BOOKSHELF, Blocks.PLANKS, Blocks.CHEST, Blocks.STONE_SLAB, Blocks.PUMPKIN, Blocks.LIT_PUMPKIN};
    private final float effectiveWeaponDamage = 4.0f + Item.ToolMaterial.WOOD.getAttackDamage();

    public ItemBoline() {
        super(Item.ToolMaterial.IRON);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void addInformation(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag moreTips) {
        String localText = WitcheryResurrected.translate(this.getTranslationKey() + ".tip", new Object[0]);
        for (String s : localText.split("\n")) {
            if (s.isEmpty()) continue;
            list2.add(s);
        }
    }

    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot slot) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)this.effectiveWeaponDamage, 0));
        }
        return multimap;
    }

    public float getAttackDamage() {
        return Item.ToolMaterial.WOOD.getAttackDamage();
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        Block block = state.getBlock();
        if (block != Blocks.AIR && block != Blocks.LEAVES && block != Blocks.WEB && block != Blocks.TALLGRASS && block != Blocks.VINE && block != Blocks.TRIPWIRE && !(block instanceof IShearable) && block.getBlockHardness(state, world, pos) != 0.0f) {
            stack.damageItem(2, entity);
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Block block = state.getBlock();
        return block == WitcheryBlocks.WEB || block == Blocks.WEB || block == Blocks.REDSTONE_WIRE || block == Blocks.TRIPWIRE;
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        Block block = state.getBlock();
        if (block == WitcheryBlocks.WEB || block == Blocks.WEB || block == Blocks.LEAVES) {
            return 15.0f;
        }
        if (block == Blocks.WOOL || block instanceof BlockPlantMine) {
            return 5.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean itemInteractionForEntity(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.world.isRemote) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(itemstack, (IBlockAccess)entity.world, entity.getPosition())) {
                List drops = target.onSheared(itemstack, (IBlockAccess)entity.world, entity.getPosition(), EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FORTUNE, (ItemStack)itemstack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.entityDropItem(stack, 1.0f);
                    ent.motionY += (double)(rand.nextFloat() * 0.05f);
                    ent.motionX += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.motionZ += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                itemstack.damageItem(1, entity);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (player.world.isRemote) {
            return false;
        }
        World world = player.world;
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block == Blocks.AIR) {
            return false;
        }
        if (block == Blocks.WEB) {
            world.setBlockToAir(pos);
            world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), new ItemStack(state.getBlock())));
            this.onBlockDestroyed(itemstack, world, state, pos, (EntityLivingBase)player);
            return true;
        }
        if (block instanceof BlockPlantMine) {
            int meta = block.getMetaFromState(state);
            world.setBlockToAir(pos);
            world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), new ItemStack(state.getBlock(), 1, meta)));
            this.onBlockDestroyed(itemstack, world, state, pos, (EntityLivingBase)player);
            return true;
        }
        if (block == WitcheryBlocks.BLOOD_POPPY) {
            world.setBlockToAir(pos);
            world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), new ItemStack(state.getBlock())));
            this.onBlockDestroyed(itemstack, world, state, pos, (EntityLivingBase)player);
            return true;
        }
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.world, pos)) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.world, pos, EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FORTUNE, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d3 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.world, (double)pos.getX() + d, (double)pos.getY() + d2, (double)pos.getZ() + d3, stack);
                entityitem.setDefaultPickupDelay();
                player.world.spawnEntity((Entity)entityitem);
            }
            itemstack.damageItem(1, (EntityLivingBase)player);
        }
        return false;
    }
}

