/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.msrandom.witchery.item.WitcheryItemSeeds;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/item/ItemArtichokeSeed;", "Lnet/msrandom/witchery/item/WitcheryItemSeeds;", "block", "Lnet/minecraft/block/Block;", "(Lnet/minecraft/block/Block;)V", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "WitcheryResurrected"})
public final class ItemArtichokeSeed
extends WitcheryItemSeeds {
    @NotNull
    public ActionResult<ItemStack> onItemRightClick(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = player.getHeldItem(hand);
        RayTraceResult rayTrace = this.rayTrace(world, player, true);
        if (rayTrace != null && rayTrace.typeOfHit == RayTraceResult.Type.BLOCK && rayTrace.sideHit == EnumFacing.UP) {
            BlockPos blockPos = rayTrace.getBlockPos();
            EnumFacing enumFacing = rayTrace.sideHit;
            float f = (float)rayTrace.hitVec.x;
            BlockPos blockPos2 = rayTrace.getBlockPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"rayTrace.blockPos");
            float f2 = f - (float)blockPos2.getX();
            float f3 = (float)rayTrace.hitVec.y;
            BlockPos blockPos3 = rayTrace.getBlockPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"rayTrace.blockPos");
            float f4 = f3 - (float)blockPos3.getY();
            float f5 = (float)rayTrace.hitVec.z;
            BlockPos blockPos4 = rayTrace.getBlockPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"rayTrace.blockPos");
            stack.onItemUse(player, world, blockPos, hand, enumFacing, f2, f4, f5 - (float)blockPos4.getZ());
            ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"ActionResult.newResult(E\u2026ionResult.SUCCESS, stack)");
            return actionResult;
        }
        ActionResult actionResult = super.onItemRightClick(world, player, hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionResult, (String)"super.onItemRightClick(world, player, hand)");
        return actionResult;
    }

    @Override
    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return EnumPlantType.Water;
    }

    public ItemArtichokeSeed(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        super(block);
    }
}

