/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityAlluringSkull;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class ItemAlluringSkull
extends ItemBlock {
    public ItemAlluringSkull(Block par1) {
        super(par1);
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.getBlockState(pos).getMaterial().isSolid()) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.getHeldItem(hand);
        if (!player.canPlayerEdit(pos = pos.offset(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!this.block.canPlaceBlockAt(worldIn, pos)) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.isRemote) {
            TileEntityAlluringSkull tileentity;
            worldIn.setBlockState(pos, this.block.getDefaultState().withProperty((IProperty)BlockDirectional.FACING, (Comparable)facing));
            int i1 = 0;
            if (facing == EnumFacing.UP) {
                i1 = MathHelper.floor((double)((double)(player.rotationYaw * 16.0f / 360.0f) + 0.5)) & 0xF;
            }
            if ((tileentity = WitcheryTileEntities.ALLURING_SKULL.getAt((IBlockAccess)worldIn, pos)) != null) {
                tileentity.setSkullRotation(i1);
            }
        }
        stack.shrink(1);
        return EnumActionResult.SUCCESS;
    }
}

