/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J$\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J4\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/item/BloodStorage;", "", "clearBlood", "", "stack", "Lnet/minecraft/item/ItemStack;", "index", "", "getBloodName", "Lnet/minecraft/util/text/ITextComponent;", "getEntityType", "Ljava/lang/Class;", "Lnet/minecraft/entity/Entity;", "hasBlood", "", "updateBloodOwner", "id", "Ljava/util/UUID;", "type", "", "name", "entity", "Companion", "WitcheryResurrected"})
public interface BloodStorage {
    public static final Companion Companion = net.msrandom.witchery.item.BloodStorage$Companion.$$INSTANCE;

    @JvmDefault
    @NotNull
    default public ItemStack updateBloodOwner(@NotNull ItemStack stack, @NotNull Entity entity, int index) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        String type = null;
        String name2 = null;
        if (entity instanceof EntityPlayer) {
            String string = net.msrandom.witchery.item.BloodStorage$Companion.access$getPLAYER$p(Companion).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PLAYER.toString()");
            type = string;
            name2 = ITextComponent.Serializer.componentToJson((ITextComponent)((EntityPlayer)entity).getDisplayName());
        } else {
            type = String.valueOf(EntityList.getKey((Entity)entity));
            String string = name2 = entity.hasCustomName() ? ITextComponent.Serializer.componentToJson((ITextComponent)entity.getDisplayName()) : null;
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).enablePersistence();
            }
        }
        UUID uUID = entity.getUniqueID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"entity.uniqueID");
        return this.updateBloodOwner(stack, uUID, type, name2, index);
    }

    public static /* synthetic */ ItemStack updateBloodOwner$default(BloodStorage bloodStorage, ItemStack itemStack, Entity entity, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateBloodOwner");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return bloodStorage.updateBloodOwner(itemStack, entity, n);
    }

    @JvmDefault
    @NotNull
    default public ItemStack updateBloodOwner(@NotNull ItemStack stack, @NotNull UUID id, @NotNull String type, @Nullable String name2, int index) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack);
        NBTTagList list2 = tag.getTagList("Blood", 10);
        if (index >= list2.tagCount()) {
            int n3 = index - list2.tagCount() + 1;
            boolean bl = false;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                list2.appendTag((NBTBase)new NBTTagCompound());
            }
        }
        NBTTagCompound blood = list2.getCompoundTagAt(index);
        blood.setUniqueId("ID", id);
        blood.setString("Type", type);
        String string = name2;
        if (string != null) {
            String string2 = string;
            n2 = 0;
            n = 0;
            String it = string2;
            boolean bl = false;
            blood.setString("Name", it);
        }
        tag.setTag("Blood", (NBTBase)list2);
        return stack;
    }

    public static /* synthetic */ ItemStack updateBloodOwner$default(BloodStorage bloodStorage, ItemStack itemStack, UUID uUID, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateBloodOwner");
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return bloodStorage.updateBloodOwner(itemStack, uUID, string, string2, n);
    }

    @JvmDefault
    default public void clearBlood(@NotNull ItemStack stack, int index) {
        NBTTagCompound tag;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound nBTTagCompound = tag = WitcheryUtils.getOrCreateTag(stack).getTagList("Blood", 10).getCompoundTagAt(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"tag");
        for (String key : nBTTagCompound.getKeySet()) {
            tag.removeTag(key);
        }
    }

    @JvmDefault
    default public boolean hasBlood(@NotNull ItemStack stack, int index) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.hasTagCompound()) {
            return false;
        }
        NBTTagList list2 = WitcheryUtils.getOrCreateTag(stack).getTagList("Blood", 10);
        return index < list2.tagCount() && list2.getCompoundTagAt(index).hasKey("Type");
    }

    @JvmDefault
    @Nullable
    default public ITextComponent getBloodName(@NotNull ItemStack stack, int index) {
        ITextComponent iTextComponent;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.hasTagCompound()) {
            return null;
        }
        NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack).getTagList("Blood", 10).getCompoundTagAt(index);
        if (tag.hasKey("Name")) {
            iTextComponent = ITextComponent.Serializer.jsonToComponent((String)tag.getString("Name"));
        } else {
            TextComponentTranslation textComponentTranslation;
            String string = EntityList.getTranslationName((ResourceLocation)new ResourceLocation(tag.getString("Type")));
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                textComponentTranslation = new TextComponentTranslation("entity." + it + ".name", new Object[0]);
            } else {
                textComponentTranslation = null;
            }
            iTextComponent = (ITextComponent)textComponentTranslation;
        }
        return iTextComponent;
    }

    public static /* synthetic */ ITextComponent getBloodName$default(BloodStorage bloodStorage, ItemStack itemStack, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBloodName");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return bloodStorage.getBloodName(itemStack, n);
    }

    @JvmDefault
    @Nullable
    default public Class<? extends Entity> getEntityType(@NotNull ItemStack stack, int index) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!stack.hasTagCompound()) {
            return null;
        }
        NBTTagCompound tag = WitcheryUtils.getOrCreateTag(stack).getTagList("Blood", 10).getCompoundTagAt(index);
        ResourceLocation name2 = new ResourceLocation(tag.getString("Type"));
        return Intrinsics.areEqual((Object)name2, (Object)net.msrandom.witchery.item.BloodStorage$Companion.access$getPLAYER$p(Companion)) ? EntityPlayer.class : EntityList.getClass((ResourceLocation)name2);
    }

    public static /* synthetic */ Class getEntityType$default(BloodStorage bloodStorage, ItemStack itemStack, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getEntityType");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return bloodStorage.getEntityType(itemStack, n);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/item/BloodStorage$Companion;", "", "()V", "PLAYER", "Lnet/minecraft/util/ResourceLocation;", "WitcheryResurrected"})
    public static final class Companion {
        private static final ResourceLocation PLAYER;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            PLAYER = new ResourceLocation("player");
        }

        public static final /* synthetic */ ResourceLocation access$getPLAYER$p(Companion $this) {
            Companion companion = $this;
            return PLAYER;
        }
    }
}

