/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.msrandom.witchery.item.ItemLeonardsUrn;

public class InventoryLeonardsUrn
extends InventoryBasic {
    protected final EntityPlayer player;
    protected final ItemStack urnStack;
    protected String title;
    protected boolean locked = false;

    public InventoryLeonardsUrn(EntityPlayer player, ItemStack stack) {
        super("", false, ((ItemLeonardsUrn)stack.getItem()).getSlots());
        this.urnStack = stack;
        this.player = player;
        if (!this.hasInventory()) {
            this.createInventory();
        }
        this.readFromNBT();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
        super.markDirty();
        if (!this.locked) {
            this.writeToNBT();
        }
    }

    public void openInventory(EntityPlayer player) {
        this.readFromNBT();
    }

    public void closeInventory(EntityPlayer player) {
        this.writeToNBT();
    }

    public String getName() {
        return this.title;
    }

    protected boolean hasInventory() {
        if (!this.urnStack.isEmpty()) {
            return this.urnStack.hasTagCompound() && this.urnStack.getTagCompound().hasKey("Inventory");
        }
        return !this.player.getHeldItemMainhand().isEmpty() && this.player.getHeldItemMainhand().hasTagCompound() && this.player.getHeldItemMainhand().getTagCompound().hasKey("Inventory");
    }

    protected void createInventory() {
        this.title = !this.urnStack.isEmpty() ? this.urnStack.getDisplayName() : this.player.getHeldItemMainhand().getDisplayName();
        this.writeToNBT();
    }

    protected void writeToNBT() {
        if (!this.urnStack.hasTagCompound()) {
            this.urnStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound nbtRoot = this.urnStack.getTagCompound();
        NBTTagCompound name2 = new NBTTagCompound();
        name2.setString("Name", this.getName());
        nbtRoot.setTag("display", (NBTBase)name2);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i).isEmpty()) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.setByte("Slot", (byte)i);
            this.getStackInSlot(i).writeToNBT(slotEntry);
            itemList.appendTag((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.setTag("Items", (NBTBase)itemList);
        nbtRoot.setTag("Inventory", (NBTBase)inventory);
    }

    protected void readFromNBT() {
        this.locked = true;
        if (this.urnStack.hasTagCompound()) {
            NBTTagCompound nbtRoot = this.urnStack.getTagCompound();
            this.title = nbtRoot.getCompoundTag("display").getString("Name");
            NBTTagList itemList = nbtRoot.getCompoundTag("Inventory").getTagList("Items", 10);
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound slotEntry = itemList.getCompoundTagAt(i);
                int j = slotEntry.getByte("Slot") & 0xFF;
                if (j >= this.getSizeInventory()) continue;
                this.setInventorySlotContents(j, new ItemStack(slotEntry));
            }
        }
        this.locked = false;
    }
}

