/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class InventoryBrewBag
extends InventoryBasic {
    protected final EntityPlayer player;
    protected String title;
    protected boolean locked = false;

    public InventoryBrewBag(EntityPlayer player) {
        super("", false, 8);
        this.player = player;
        if (!this.hasInventory()) {
            this.createInventory();
        }
        this.readFromNBT();
    }

    public void markDirty() {
        super.markDirty();
        if (!this.locked) {
            this.writeToNBT();
        }
    }

    public void openInventory(EntityPlayer player) {
        this.readFromNBT();
    }

    public void closeInventory(EntityPlayer player) {
        this.writeToNBT();
    }

    public String getName() {
        return this.title;
    }

    protected boolean hasInventory() {
        ItemStack bag = this.player.isHandActive() ? this.player.getActiveItemStack() : ItemStack.EMPTY;
        return !bag.isEmpty() && bag.hasTagCompound() && bag.getTagCompound().hasKey("Inventory");
    }

    protected void createInventory() {
        ItemStack bag = this.player.isHandActive() ? this.player.getActiveItemStack() : ItemStack.EMPTY;
        this.title = bag.getDisplayName();
        this.writeToNBT();
    }

    public void writeToNBT() {
        ItemStack bag;
        ItemStack itemStack = bag = this.player.isHandActive() ? this.player.getActiveItemStack() : ItemStack.EMPTY;
        if (bag.getItem() == WitcheryGeneralItems.BREW_BAG) {
            if (!bag.hasTagCompound()) {
                bag.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = bag.getTagCompound();
            NBTTagCompound name2 = new NBTTagCompound();
            name2.setString("Name", this.getName());
            nbtRoot.setTag("display", (NBTBase)name2);
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (this.getStackInSlot(i).isEmpty()) continue;
                NBTTagCompound slotEntry = new NBTTagCompound();
                slotEntry.setByte("Slot", (byte)i);
                this.getStackInSlot(i).writeToNBT(slotEntry);
                itemList.appendTag((NBTBase)slotEntry);
            }
            NBTTagCompound inventory = new NBTTagCompound();
            inventory.setTag("Items", (NBTBase)itemList);
            nbtRoot.setTag("Inventory", (NBTBase)inventory);
        }
    }

    protected void readFromNBT() {
        ItemStack bag;
        this.locked = true;
        ItemStack itemStack = bag = this.player.isHandActive() ? this.player.getActiveItemStack() : ItemStack.EMPTY;
        if (bag.getItem() == WitcheryGeneralItems.BREW_BAG && bag.hasTagCompound()) {
            NBTTagCompound nbtRoot = bag.getTagCompound();
            this.title = nbtRoot.getCompoundTag("display").getString("Name");
            NBTTagList itemList = nbtRoot.getCompoundTag("Inventory").getTagList("Items", 10);
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound slotEntry = itemList.getCompoundTagAt(i);
                int j = slotEntry.getByte("Slot") & 0xFF;
                if (j >= this.getSizeInventory()) continue;
                this.setInventorySlotContents(j, new ItemStack(slotEntry));
            }
        }
        this.locked = false;
    }
}

