/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityWitchesOven;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.inventory.SlotClayJar;

public class ContainerWitchesOven
extends Container {
    public final TileEntityWitchesOven oven;
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemBurnTime;

    public ContainerWitchesOven(EntityPlayer player, BlockPos pos) {
        int i;
        this.oven = Objects.requireNonNull(WitcheryTileEntities.WITCHES_OVEN.getAt((IBlockAccess)player.world, pos));
        this.addSlotToContainer(new Slot((IInventory)this.oven, 0, 56, 17));
        this.addSlotToContainer(new SlotClayJar((IInventory)this.oven, 1, 31, 53));
        this.addSlotToContainer((Slot)new SlotFurnaceFuel((IInventory)this.oven, 2, 56, 53));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.oven, 3, 116, 21));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.oven, 4, 116, 53));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, i, 8 + i * 18, 142));
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendAllWindowProperties((Container)this, (IInventory)this.oven);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener icrafting : this.listeners) {
            if (this.lastCookTime != this.oven.getField(0)) {
                icrafting.sendWindowProperty((Container)this, 0, this.oven.getField(0));
            }
            if (this.lastBurnTime != this.oven.getField(1)) {
                icrafting.sendWindowProperty((Container)this, 1, this.oven.getField(1));
            }
            if (this.lastItemBurnTime == this.oven.getField(2)) continue;
            icrafting.sendWindowProperty((Container)this, 2, this.oven.getField(2));
        }
        this.lastCookTime = this.oven.getField(0);
        this.lastBurnTime = this.oven.getField(1);
        this.lastItemBurnTime = this.oven.getField(2);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        this.oven.setField(id, data);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.oven.isUsableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack2 = slot.getStack();
            itemstack = itemstack2.copy();
            if (slotIndex == 3 || slotIndex == 4) {
                if (!this.mergeItemStack(itemstack2, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack2, itemstack);
            } else if (slotIndex != 2 && slotIndex != 0 && slotIndex != 1 ? (!FurnaceRecipes.instance().getSmeltingResult(itemstack2).isEmpty() ? !this.mergeItemStack(itemstack2, 0, 1, false) : (TileEntityFurnace.isItemFuel((ItemStack)itemstack2) ? !this.mergeItemStack(itemstack2, 2, 3, false) : (itemstack2.getItem() == WitcheryFumeItems.CLAY_JAR ? !this.mergeItemStack(itemstack2, 1, 2, false) : (slotIndex < 32 ? !this.mergeItemStack(itemstack2, 32, 41, false) : slotIndex < 41 && !this.mergeItemStack(itemstack2, 5, 32, false))))) : !this.mergeItemStack(itemstack2, 5, 41, false)) {
                return ItemStack.EMPTY;
            }
            slot.onSlotChanged();
            if (itemstack2.getCount() == itemstack.getCount()) {
                return null;
            }
            slot.onTake(player, itemstack2);
        }
        return itemstack;
    }
}

