/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntitySpinningWheel;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.SpinningWheelRecipe;
import net.msrandom.witchery.util.WitcheryUtils;

public class ContainerSpinningWheel
extends Container {
    public final TileEntitySpinningWheel spinningWheel;
    private int lastCookTime;
    private int lastPowerLevel;

    public ContainerSpinningWheel(EntityPlayer player, BlockPos pos) {
        int i;
        this.spinningWheel = Objects.requireNonNull(WitcheryTileEntities.SPINNING_WHEEL.getAt((IBlockAccess)player.world, pos));
        this.addSlotToContainer(new Slot((IInventory)this.spinningWheel, 0, 56, 26));
        this.addSlotToContainer(new Slot((IInventory)this.spinningWheel, 1, 38, 48));
        this.addSlotToContainer(new Slot((IInventory)this.spinningWheel, 2, 56, 48));
        this.addSlotToContainer(new Slot((IInventory)this.spinningWheel, 3, 74, 48));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.spinningWheel, 4, 116, 27));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, i, 8 + i * 18, 142));
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendAllWindowProperties((Container)this, (IInventory)this.spinningWheel);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener icrafting : this.listeners) {
            if (this.lastCookTime != this.spinningWheel.getField(0)) {
                icrafting.sendWindowProperty((Container)this, 0, this.spinningWheel.getField(0));
            }
            if (this.lastPowerLevel == this.spinningWheel.getField(1)) continue;
            icrafting.sendWindowProperty((Container)this, 1, this.spinningWheel.getField(1));
        }
        this.lastCookTime = this.spinningWheel.getField(0);
        this.lastPowerLevel = this.spinningWheel.getField(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        this.spinningWheel.setField(id, data);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.spinningWheel.isUsableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            List<SpinningWheelRecipe> recipes;
            ItemStack itemstack2 = slot.getStack();
            itemstack = itemstack2.copy();
            if (slotIndex == 4) {
                if (!this.mergeItemStack(itemstack2, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack2, itemstack);
            } else if (slotIndex != 1 && slotIndex != 0 && slotIndex != 3 && slotIndex != 2 ? (CollectionsKt.any(recipes = WitcheryUtils.getRecipeManager(player.world).getRecipesForType(WitcheryRecipeTypes.SPINNING_WHEEL), it -> it.getFibre().test((Object)itemstack2)) && (this.spinningWheel.getStackInSlot(0).isEmpty() || this.spinningWheel.getStackInSlot(0).isItemEqual(itemstack2)) ? !this.mergeItemStack(itemstack2, 0, 1, false) : (CollectionsKt.any(recipes, it -> CollectionsKt.any(it.getModifiers(), modifier -> modifier.test((Object)itemstack2))) ? !this.mergeItemStack(itemstack2, 1, 2, false) && !this.mergeItemStack(itemstack2, 2, 3, false) && !this.mergeItemStack(itemstack2, 3, 4, false) : (slotIndex < 32 ? !this.mergeItemStack(itemstack2, 32, 41, false) : slotIndex < 41 && !this.mergeItemStack(itemstack2, 5, 32, false)))) : !this.mergeItemStack(itemstack2, 5, 41, false)) {
                return ItemStack.EMPTY;
            }
            slot.onSlotChanged();
            if (itemstack2.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack2);
        }
        return itemstack;
    }
}

