/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.msrandom.witchery.inventory.InventoryLeonardsUrn;
import net.msrandom.witchery.inventory.SlotBrew;
import net.msrandom.witchery.item.ItemLeonardsUrn;

public class ContainerLeonardsUrn
extends Container {
    public final EntityPlayer player;
    public final InventoryLeonardsUrn urnInventory;

    public ContainerLeonardsUrn(EntityPlayer player, BlockPos pos) {
        this.player = player;
        this.urnInventory = new InventoryLeonardsUrn(player, player.getHeldItem(player.getActiveHand()));
        this.urnInventory.openInventory(player);
        int size = this.urnInventory.getSizeInventory();
        int slot = 0;
        this.addSlotToContainer(new SlotBrew((IInventory)this.urnInventory, slot++, 80, 22, true));
        if (size >= 2) {
            this.addSlotToContainer(new SlotBrew((IInventory)this.urnInventory, slot++, 80, 70, true));
        }
        if (size >= 3) {
            this.addSlotToContainer(new SlotBrew((IInventory)this.urnInventory, slot++, 103, 46, true));
        }
        if (size >= 4) {
            this.addSlotToContainer(new SlotBrew((IInventory)this.urnInventory, slot, 56, 46, true));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, col + row * 9 + 9, 8 + col * 18, 103 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, col2, 8 + col2 * 18, 161));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return player.getHeldItem(player.getActiveHand()).getItem() instanceof ItemLeonardsUrn;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack = slot.getStack();
            if (!SlotBrew.isBrew(itemStack, true)) {
                return returnStack;
            }
            returnStack = itemStack.copy();
            if (index < 9 ? !this.mergeItemStack(itemStack, 9, this.inventorySlots.size(), true) : !this.mergeItemStack(itemStack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            slot.onSlotChanged();
        }
        return returnStack;
    }

    protected boolean mergeItemStack(ItemStack stack, int slotCount, int invSize, boolean upper) {
        ItemStack itemstack1;
        Slot slot;
        int maxStackSize;
        boolean flag1 = false;
        int k = slotCount;
        if (upper) {
            k = invSize - 1;
        }
        int n = maxStackSize = upper ? stack.getMaxStackSize() : 1;
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (!upper && k < invSize || upper && k >= slotCount)) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!(itemstack1.isEmpty() || itemstack1.getItem() != stack.getItem() || stack.getHasSubtypes() && stack.getItemDamage() != itemstack1.getItemDamage() || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack1))) {
                    int l = itemstack1.getCount() + stack.getCount();
                    if (l <= maxStackSize) {
                        stack.setCount(0);
                        itemstack1.setCount(l);
                        slot.onSlotChanged();
                        flag1 = true;
                    } else if (itemstack1.getCount() < maxStackSize) {
                        stack.shrink(maxStackSize - itemstack1.getCount());
                        itemstack1.setCount(maxStackSize);
                        slot.onSlotChanged();
                        flag1 = true;
                    }
                }
                if (upper) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (stack.getCount() > 0) {
            k = upper ? invSize - 1 : slotCount;
            while (!upper && k < invSize || upper && k >= slotCount) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (itemstack1.isEmpty()) {
                    slot.putStack(upper ? stack.copy() : stack.splitStack(1));
                    slot.onSlotChanged();
                    if (upper) {
                        stack.setCount(0);
                    }
                    flag1 = true;
                    break;
                }
                if (upper) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }
}

