/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityDistillery;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.inventory.SlotClayJar;

public class ContainerDistillery
extends Container {
    public final TileEntityDistillery distillery;
    private int lastCookTime;
    private int lastPowerLevel;

    public ContainerDistillery(EntityPlayer player, BlockPos pos) {
        int i;
        this.distillery = Objects.requireNonNull(WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)player.world, pos));
        this.addSlotToContainer(new Slot((IInventory)this.distillery, 0, 56, 15));
        this.addSlotToContainer(new Slot((IInventory)this.distillery, 1, 56, 33));
        this.addSlotToContainer(new SlotClayJar((IInventory)this.distillery, 2, 56, 55));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.distillery, 3, 112, 26));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.distillery, 4, 130, 26));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.distillery, 5, 112, 44));
        this.addSlotToContainer((Slot)new SlotFurnaceOutput(player, (IInventory)this.distillery, 6, 130, 44));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, i, 8 + i * 18, 142));
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendAllWindowProperties((Container)this, (IInventory)this.distillery);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener icrafting : this.listeners) {
            if (this.lastCookTime != this.distillery.getField(0)) {
                icrafting.sendWindowProperty((Container)this, 0, this.distillery.getField(0));
            }
            if (this.lastPowerLevel == this.distillery.getField(1)) continue;
            icrafting.sendWindowProperty((Container)this, 1, this.distillery.getField(1));
        }
        this.lastCookTime = this.distillery.getField(0);
        this.lastPowerLevel = this.distillery.getField(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        this.distillery.setField(id, data);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.distillery.isUsableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack2 = slot.getStack();
            itemstack = itemstack2.copy();
            if (slotIndex >= 3 && slotIndex <= 6) {
                if (!this.mergeItemStack(itemstack2, 7, 43, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack2, itemstack);
            } else if (slotIndex != 1 && slotIndex != 0 && slotIndex != 2 ? (!FurnaceRecipes.instance().getSmeltingResult(itemstack2).isEmpty() ? !this.mergeItemStack(itemstack2, 0, 2, false) : (itemstack2.getItem() == WitcheryFumeItems.CLAY_JAR ? !this.mergeItemStack(itemstack2, 2, 3, false) : (slotIndex < 34 ? !this.mergeItemStack(itemstack2, 34, 43, false) : slotIndex < 43 && !this.mergeItemStack(itemstack2, 7, 34, false)))) : !this.mergeItemStack(itemstack2, 7, 43, false)) {
                return ItemStack.EMPTY;
            }
            slot.onSlotChanged();
            if (itemstack2.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack2);
        }
        return itemstack;
    }
}

