/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.inventory.InventoryBrewBag;
import net.msrandom.witchery.inventory.SlotBrew;

public class ContainerBrewBag
extends Container {
    public final EntityPlayer player;
    public final InventoryBrewBag bagInventory;
    public final int numRows;

    public ContainerBrewBag(EntityPlayer player, BlockPos pos) {
        int col;
        int row;
        this.player = player;
        this.bagInventory = new InventoryBrewBag(player);
        this.numRows = this.bagInventory.getSizeInventory() / 8;
        this.bagInventory.openInventory(player);
        int offset = (this.numRows - 4) * 18;
        for (row = 0; row < this.numRows; ++row) {
            for (col = 0; col < 8; ++col) {
                this.addSlotToContainer(new SlotBrew((IInventory)this.bagInventory, col + row * 8, 16 + col * 18, 18 + row * 18, false));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, col + row * 9 + 9, 8 + col * 18, 103 + row * 18 + offset));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, col2, 8 + col2 * 18, 161 + offset));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return player.isHandActive() && player.getActiveItemStack().getItem() == WitcheryGeneralItems.BREW_BAG;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack = slot.getStack();
            if (!SlotBrew.isBrew(itemStack, false)) {
                return returnStack;
            }
            returnStack = itemStack.copy();
            if (index < this.numRows * 9 ? !this.mergeItemStack(itemStack, this.numRows * 9, this.inventorySlots.size(), true) : !this.mergeItemStack(itemStack, 0, this.numRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            slot.onSlotChanged();
        }
        return returnStack;
    }
}

